/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.util;

import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CPropertyVisitor;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomizationUtils {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocumentBuilder() {
        try {
            return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new AssertionError((Object)pce);
        }
    }

    public static CPluginCustomization createCustomization(QName name) {
        Document document = CustomizationUtils.getDocumentBuilder().newDocument();
        Element element = document.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        return CustomizationUtils.createCustomization(element);
    }

    public static CPluginCustomization createCustomization(Element element) {
        CPluginCustomization customization = new CPluginCustomization(element, null);
        return customization;
    }

    public static boolean containsCustomization(ClassOutline classOutline, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(classOutline, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static boolean containsCustomization(CClassInfo classInfo, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(classInfo, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static CPluginCustomization findCustomization(ClassOutline classOutline, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(classOutline);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(CClassInfo classInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(classInfo);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static boolean containsCustomization(FieldOutline fieldOutline, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(fieldOutline, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static boolean containsCustomization(CPropertyInfo propertyInfo, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization(propertyInfo, name);
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization != null;
    }

    public static CPluginCustomization findCustomization(FieldOutline fieldOutline, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(fieldOutline);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(CPropertyInfo propertyInfo, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(propertyInfo);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static CPluginCustomization findCustomization(Model model, QName name) {
        CCustomizations customizations = CustomizationUtils.getCustomizations(model);
        CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
        if (customization != null) {
            customization.markAsAcknowledged();
        }
        return customization;
    }

    public static FieldOutline findFieldWithCustomization(ClassOutline classOutline, QName name) {
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            CCustomizations customizations = CustomizationUtils.getCustomizations(fieldOutline);
            CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
            if (customization == null) continue;
            return fieldOutline;
        }
        return null;
    }

    public static CPropertyInfo findPropertyWithCustomization(CClassInfo classInfo, QName name) {
        for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
            CCustomizations customizations = CustomizationUtils.getCustomizations(propertyInfo);
            CPluginCustomization customization = customizations.find(name.getNamespaceURI(), name.getLocalPart());
            if (customization == null) continue;
            return propertyInfo;
        }
        return null;
    }

    public static FieldOutline findInheritedFieldWithCustomization(ClassOutline classOutline, QName name) {
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            if (!CustomizationUtils.containsCustomization(fieldOutline, name)) continue;
            return fieldOutline;
        }
        ClassOutline superClassOutline = classOutline.getSuperClass();
        if (superClassOutline != null) {
            return CustomizationUtils.findInheritedFieldWithCustomization(superClassOutline, name);
        }
        return null;
    }

    public static CPropertyInfo findInheritedPropertyWithCustomization(CClassInfo classInfo, QName name) {
        for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
            if (!CustomizationUtils.containsCustomization(propertyInfo, name)) continue;
            return propertyInfo;
        }
        CClassInfo superClassInfo = classInfo.getBaseClass();
        if (superClassInfo != null) {
            return CustomizationUtils.findInheritedPropertyWithCustomization(superClassInfo, name);
        }
        return null;
    }

    public static CCustomizations getCustomizations(FieldOutline fieldOutline) {
        return CustomizationUtils.getCustomizations(fieldOutline.getPropertyInfo());
    }

    public static CCustomizations getCustomizations(Model model) {
        CCustomizations main = new CCustomizations((Collection)model.getCustomizations());
        return main;
    }

    public static CCustomizations getCustomizations(CPropertyInfo propertyInfo) {
        CCustomizations main = new CCustomizations((Collection)propertyInfo.getCustomizations());
        Collection elementCustomizations = (Collection)propertyInfo.accept((CPropertyVisitor)new CPropertyVisitor<Collection<CCustomizations>>(){

            public Collection<CCustomizations> onAttribute(CAttributePropertyInfo info) {
                return Collections.emptyList();
            }

            public Collection<CCustomizations> onElement(CElementPropertyInfo arg0) {
                return Collections.emptyList();
            }

            public Collection<CCustomizations> onReference(CReferencePropertyInfo info) {
                ArrayList<CCustomizations> elementCustomizations = new ArrayList<CCustomizations>(info.getElements().size());
                for (CElement element : info.getElements()) {
                    elementCustomizations.add(element.getCustomizations());
                }
                return elementCustomizations;
            }

            public Collection<CCustomizations> onValue(CValuePropertyInfo arg0) {
                return Collections.emptyList();
            }
        });
        CCustomizations customizations = main;
        for (CCustomizations e : elementCustomizations) {
            main.addAll((Collection)e);
        }
        return customizations;
    }

    public static CCustomizations getCustomizations(ClassOutline classOutline) {
        return CustomizationUtils.getCustomizations(classOutline.target);
    }

    public static CCustomizations getCustomizations(CClassInfo classInfo) {
        return classInfo.getCustomizations();
    }
}

