/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.localizer;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.jvnet.localizer.GeneratorBase;
import org.jvnet.localizer.GeneratorConfig;

public abstract class CodeModelGenerator
extends GeneratorBase {
    protected final JCodeModel cm = new JCodeModel();

    public CodeModelGenerator(GeneratorConfig config) {
        super(config);
    }

    public JCodeModel getCodeModel() {
        return this.cm;
    }

    @Override
    public void build() throws IOException {
        this.outputDirectory.mkdirs();
        this.cm.build(new CodeWriter(){
            private final CodeWriter delegate;
            {
                this.delegate = new FileCodeWriter(CodeModelGenerator.this.outputDirectory, CodeModelGenerator.this.outputEncoding);
            }

            public Writer openSource(JPackage pkg, String fileName) throws IOException {
                this.encoding = CodeModelGenerator.this.outputEncoding;
                Writer w = super.openSource(pkg, fileName);
                new PrintWriter(w).println("// CHECKSTYLE:OFF");
                return w;
            }

            public void close() throws IOException {
                this.delegate.close();
            }

            public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
                return this.delegate.openBinary(pkg, fileName);
            }
        });
    }
}

