/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.localizer;

import java.io.File;
import java.util.regex.Pattern;
import org.jvnet.localizer.Reporter;

public class GeneratorConfig {
    private File outputDirectory;
    private String outputEncoding;
    private Reporter reporter;
    private Pattern keyPattern;
    private boolean strictTypes;
    private boolean accessModifierAnnotations;

    public boolean isAccessModifierAnnotations() {
        return this.accessModifierAnnotations;
    }

    public void setAccessModifierAnnotations(boolean accessModifierAnnotations) {
        this.accessModifierAnnotations = accessModifierAnnotations;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public Pattern getKeyPattern() {
        return this.keyPattern;
    }

    public void setKeyPattern(Pattern keyPattern) {
        this.keyPattern = keyPattern;
    }

    public void setKeyPattern(String keyPattern) {
        this.keyPattern = keyPattern != null && !"".equals(keyPattern) ? Pattern.compile(keyPattern) : null;
    }

    public boolean isStrictTypes() {
        return this.strictTypes;
    }

    public void setStrictTypes(boolean strictTypes) {
        this.strictTypes = strictTypes;
    }

    public static GeneratorConfig of(File outputDirectory, String outputEncoding, Reporter reporter, String keyPattern) {
        return GeneratorConfig.of(outputDirectory, outputEncoding, reporter, keyPattern, false);
    }

    public static GeneratorConfig of(File outputDirectory, String outputEncoding, Reporter reporter, String keyPattern, boolean strictTypes) {
        return GeneratorConfig.of(outputDirectory, outputEncoding, reporter, keyPattern, strictTypes, false);
    }

    public static GeneratorConfig of(File outputDirectory, String outputEncoding, Reporter reporter, String keyPattern, boolean strictTypes, boolean accessModifierAnnotations) {
        GeneratorConfig config = new GeneratorConfig();
        config.setOutputDirectory(outputDirectory);
        config.setOutputEncoding(outputEncoding);
        config.setReporter(reporter);
        config.setKeyPattern(keyPattern);
        config.setStrictTypes(strictTypes);
        config.setAccessModifierAnnotations(accessModifierAnnotations);
        return config;
    }
}

