/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.localizer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jvnet.localizer.ClassGenerator;
import org.jvnet.localizer.GeneratorConfig;
import org.jvnet.localizer.Reporter;

public class GeneratorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected String fileMask;
    protected String outputEncoding;
    protected String keyPattern;
    protected String generatorClass;
    protected boolean strictTypes;
    protected boolean accessModifierAnnotations;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String pkg = this.project.getPackaging();
        if (pkg != null && pkg.equals("pom")) {
            return;
        }
        GeneratorConfig config = GeneratorConfig.of(this.outputDirectory, this.outputEncoding, new Reporter(){

            public void debug(String msg) {
                GeneratorMojo.this.getLog().debug((CharSequence)msg);
            }
        }, this.keyPattern, this.strictTypes, this.accessModifierAnnotations);
        ClassGenerator g = this.createGenerator(config);
        for (Resource res : this.project.getResources()) {
            File baseDir = new File(res.getDirectory());
            if (!baseDir.exists()) continue;
            FileSet fs = new FileSet();
            fs.setDir(baseDir);
            for (String name : res.getIncludes()) {
                fs.createInclude().setName(name);
            }
            for (String name : res.getExcludes()) {
                fs.createExclude().setName(name);
            }
            try {
                DirectoryScanner ds = fs.getDirectoryScanner(new Project());
                g.generate(baseDir, ds, new FileFilter(){

                    public boolean accept(File f) {
                        if (!f.getName().endsWith(".properties") || f.getName().contains("_")) {
                            return false;
                        }
                        return GeneratorMojo.this.fileMask == null || f.getName().equals(GeneratorMojo.this.fileMask);
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to generate class", (Exception)e);
            }
        }
        try {
            g.build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate source file(s)", (Exception)e);
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private ClassGenerator createGenerator(GeneratorConfig config) throws MojoExecutionException {
        Constructor<ClassGenerator> cstr;
        Class<?> clazz;
        try {
            clazz = Class.forName(this.generatorClass);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Cannot load ClassGenerator class \"" + this.generatorClass + "\".");
        }
        try {
            cstr = clazz.asSubclass(ClassGenerator.class).getDeclaredConstructor(GeneratorConfig.class);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException("generatorClass \"" + this.generatorClass + "\" is not an implementation of ClassGenerator.");
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("GeneratorClass must have visible constructor accepting GeneratorConfig as parameter.", (Exception)e);
        }
        catch (SecurityException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            return cstr.newInstance(config);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create instance of ClassGenerator \"" + this.generatorClass + "\".", e);
        }
    }
}

