/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kairosdb.client.Client;
import org.kairosdb.client.ClientResponse;
import org.kairosdb.client.builder.MetricBuilder;
import org.kairosdb.client.builder.QueryBuilder;
import org.kairosdb.client.deserializer.GroupByDeserializer;
import org.kairosdb.client.deserializer.ResultsDeserializer;
import org.kairosdb.client.response.ErrorResponse;
import org.kairosdb.client.response.GetResponse;
import org.kairosdb.client.response.GroupResult;
import org.kairosdb.client.response.QueryResponse;
import org.kairosdb.client.response.Response;
import org.kairosdb.client.response.Results;
import org.kairosdb.client.util.Preconditions;

public abstract class AbstractClient
implements Client {
    private String url;
    private Gson mapper;
    private Map<String, Class> customGroupTypes = new HashMap<String, Class>();

    protected AbstractClient(String url) throws MalformedURLException {
        this.url = Preconditions.checkNotNullOrEmpty(url);
        new URL(url);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GroupResult.class, (Object)new GroupByDeserializer());
        builder.registerTypeAdapter(Results.class, (Object)new ResultsDeserializer(this));
        this.mapper = builder.create();
        this.customGroupTypes.put("number", Number.class);
        this.customGroupTypes.put("text", String.class);
    }

    @Override
    public GetResponse getMetricNames() throws IOException {
        return this.get(this.url + "/api/v1/metricnames");
    }

    @Override
    public GetResponse getTagNames() throws IOException {
        return this.get(this.url + "/api/v1/tagnames");
    }

    @Override
    public GetResponse getTagValues() throws IOException {
        return this.get(this.url + "/api/v1/tagvalues");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResponse query(QueryBuilder builder) throws URISyntaxException, IOException {
        ClientResponse clientResponse = this.postData(builder.build(), this.url + "/api/v1/datapoints/query");
        int responseCode = clientResponse.getStatusCode();
        InputStream stream = clientResponse.getContentStream();
        if (stream != null) {
            InputStreamReader reader = new InputStreamReader(stream);
            try {
                if (responseCode >= 400) {
                    QueryResponse response = new QueryResponse();
                    response.setStatusCode(responseCode);
                    ErrorResponse errorResponse = (ErrorResponse)this.mapper.fromJson((Reader)reader, ErrorResponse.class);
                    response.addErrors(errorResponse.getErrors());
                    QueryResponse queryResponse = response;
                    return queryResponse;
                }
                QueryResponse response = (QueryResponse)this.mapper.fromJson((Reader)reader, QueryResponse.class);
                response.setStatusCode(responseCode);
                QueryResponse queryResponse = response;
                return queryResponse;
            }
            finally {
                reader.close();
            }
        }
        QueryResponse response = new QueryResponse();
        response.setStatusCode(responseCode);
        return response;
    }

    @Override
    public Response pushMetrics(MetricBuilder builder) throws URISyntaxException, IOException {
        com.google.common.base.Preconditions.checkNotNull((Object)builder);
        ClientResponse clientResponse = this.postData(builder.build(), this.url + "/api/v1/datapoints");
        return this.getResponse(clientResponse);
    }

    @Override
    public Response deleteMetric(String name) throws IOException {
        Preconditions.checkNotNullOrEmpty(name);
        ClientResponse response = this.delete(this.url + "/api/v1/metric/" + name);
        return this.getResponse(response);
    }

    @Override
    public Response delete(QueryBuilder builder) throws URISyntaxException, IOException {
        com.google.common.base.Preconditions.checkNotNull((Object)builder);
        ClientResponse clientResponse = this.postData(builder.build(), this.url + "/api/v1/datapoints/delete");
        return this.getResponse(clientResponse);
    }

    @Override
    public void registerCustomDataType(String groupType, Class dataPointClass) {
        com.google.common.base.Preconditions.checkArgument((!this.customGroupTypes.containsKey(groupType) ? 1 : 0) != 0, (Object)"Type has already been registered");
        this.customGroupTypes.put(groupType, dataPointClass);
    }

    @Override
    public Class getDataPointValueClass(String groupType) {
        return this.customGroupTypes.get(groupType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getResponse(ClientResponse clientResponse) throws IOException {
        Response response = new Response(clientResponse.getStatusCode());
        InputStream stream = clientResponse.getContentStream();
        if (stream != null) {
            InputStreamReader reader = new InputStreamReader(stream);
            try {
                ErrorResponse errorResponse = (ErrorResponse)this.mapper.fromJson((Reader)reader, ErrorResponse.class);
                response.addErrors(errorResponse.getErrors());
            }
            finally {
                reader.close();
            }
        }
        return response;
    }

    private GetResponse get(String url) throws IOException {
        ClientResponse clientResponse = this.queryData(url);
        int responseCode = clientResponse.getStatusCode();
        if (responseCode >= 400) {
            return new GetResponse(responseCode);
        }
        InputStream stream = clientResponse.getContentStream();
        if (stream == null) {
            throw new IOException("Could not get content stream.");
        }
        return new GetResponse(responseCode, this.readNameQueryResponse(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readNameQueryResponse(InputStream stream) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, "UTF-8"));
        try {
            reader.beginObject();
            String container = reader.nextName();
            if (container.equals("results")) {
                reader.beginArray();
                while (reader.hasNext()) {
                    list.add(reader.nextString());
                }
                reader.endArray();
                reader.endObject();
            }
        }
        finally {
            reader.close();
        }
        return list;
    }

    protected abstract ClientResponse postData(String var1, String var2) throws IOException;

    protected abstract ClientResponse queryData(String var1) throws IOException;

    protected abstract ClientResponse delete(String var1) throws IOException;
}

