/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.kairosdb.client.AbstractClient;
import org.kairosdb.client.ClientResponse;
import org.kairosdb.client.HttpClientResponse;

public class HttpClient
extends AbstractClient {
    private CloseableHttpClient client;
    private int retries = 3;

    public HttpClient(String url) throws MalformedURLException {
        super(url);
        HttpClientBuilder builder = HttpClientBuilder.create();
        this.client = builder.build();
    }

    @Override
    protected ClientResponse postData(String json, String url) throws IOException {
        StringEntity requestEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
        HttpPost postMethod = new HttpPost(url);
        postMethod.setEntity((HttpEntity)requestEntity);
        return this.execute((HttpUriRequest)postMethod);
    }

    @Override
    protected ClientResponse queryData(String url) throws IOException {
        HttpGet getMethod = new HttpGet(url);
        getMethod.addHeader("accept", "application/json");
        return this.execute((HttpUriRequest)getMethod);
    }

    @Override
    protected ClientResponse delete(String url) throws IOException {
        HttpDelete deleteMethod = new HttpDelete(url);
        deleteMethod.addHeader("accept", "application/json");
        return this.execute((HttpUriRequest)deleteMethod);
    }

    private ClientResponse execute(HttpUriRequest request) throws IOException {
        CloseableHttpResponse response;
        int tries = ++this.retries;
        while (true) {
            --tries;
            try {
                response = this.client.execute(request);
            }
            catch (IOException e) {
                if (tries >= 1) continue;
                throw e;
            }
            break;
        }
        return new HttpClientResponse((HttpResponse)response);
    }

    @Override
    public void shutdown() throws IOException {
        this.client.close();
    }

    @Override
    public int getRetryCount() {
        return this.retries;
    }

    public void setRetryCount(int retries) {
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0);
        this.retries = retries;
    }

    protected void setClient(CloseableHttpClient client) {
        this.client = client;
    }
}

