/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.kairosdb.client.builder.DataPoint;
import org.kairosdb.client.builder.Metric;
import org.kairosdb.client.builder.MetricBuilder;

public class TelnetClient {
    private Socket socket;
    private PrintWriter writer;

    public TelnetClient(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
        this.writer = new PrintWriter(new BufferedOutputStream(this.socket.getOutputStream()));
    }

    public void pushMetrics(MetricBuilder builder) {
        List<Metric> metrics = builder.getMetrics();
        for (Metric metric : metrics) {
            StringBuilder tags = new StringBuilder();
            for (Map.Entry<String, String> tag : metric.getTags().entrySet()) {
                tags.append(tag.getKey()).append("=").append(tag.getValue());
            }
            for (DataPoint dataPoint : metric.getDataPoints()) {
                this.writer.println("put " + metric.getName() + " " + dataPoint.getTimestamp() + " " + dataPoint.getValue() + " " + tags.toString());
            }
        }
        this.writer.flush();
    }

    public void shutdown() throws IOException {
        this.socket.close();
    }
}

