/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.base.Preconditions;
import org.kairosdb.client.builder.TimeUnit;
import org.kairosdb.client.builder.aggregator.CustomAggregator;
import org.kairosdb.client.builder.aggregator.RateAggregator;
import org.kairosdb.client.builder.aggregator.SamplingAggregator;

public class AggregatorFactory {
    public static SamplingAggregator createMinAggregator(int value, TimeUnit unit) {
        return new SamplingAggregator("min", value, unit);
    }

    public static SamplingAggregator createMaxAggregator(int value, TimeUnit unit) {
        return new SamplingAggregator("max", value, unit);
    }

    public static SamplingAggregator createAverageAggregator(int value, TimeUnit unit) {
        return new SamplingAggregator("avg", value, unit);
    }

    public static SamplingAggregator createStandardDeviationAggregator(int value, TimeUnit unit) {
        return new SamplingAggregator("dev", value, unit);
    }

    public static SamplingAggregator createSumAggregator(int value, TimeUnit unit) {
        return new SamplingAggregator("sum", value, unit);
    }

    public static SamplingAggregator createCountAggregator(int value, TimeUnit unit) {
        return new SamplingAggregator("count", value, unit);
    }

    public static CustomAggregator createDivAggregator(double divisor) {
        Preconditions.checkArgument((divisor != 0.0 ? 1 : 0) != 0, (Object)"Divisor cannot be zero.");
        return new CustomAggregator("div", "\"divisor\":" + divisor);
    }

    public static CustomAggregator createCustomAggregator(String name, String json) {
        return new CustomAggregator(name, json);
    }

    public static RateAggregator createRateAggregator(TimeUnit unit) {
        return new RateAggregator(unit);
    }
}

