/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.base.Preconditions;
import org.kairosdb.client.builder.DataFormatException;

public class DataPoint {
    private long timestamp;
    private Object value;

    public DataPoint(long timestamp, Object value) {
        Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0);
        this.timestamp = timestamp;
        this.value = Preconditions.checkNotNull((Object)value);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public String stringValue() throws DataFormatException {
        return this.value.toString();
    }

    public long longValue() throws DataFormatException {
        try {
            return ((Number)this.value).longValue();
        }
        catch (Exception e) {
            throw new DataFormatException("Value is not a long");
        }
    }

    public double doubleValue() throws DataFormatException {
        try {
            return ((Number)this.value).doubleValue();
        }
        catch (Exception e) {
            throw new DataFormatException("Value is not a double");
        }
    }

    public boolean isDoubleValue() {
        return ((Number)this.value).doubleValue() != Math.floor(((Number)this.value).doubleValue());
    }

    public boolean isIntegerValue() {
        return ((Number)this.value).doubleValue() == Math.floor(((Number)this.value).doubleValue());
    }

    public String toString() {
        return "DataPoint{timestamp=" + this.timestamp + ", value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPoint dataPoint = (DataPoint)o;
        return this.timestamp == dataPoint.timestamp && this.value.equals(dataPoint.value);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

