/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kairosdb.client.builder.DataPoint;
import org.kairosdb.client.util.Preconditions;

public class Metric {
    private String name;
    private Map<String, String> tags = new HashMap<String, String>();
    private String type;
    @SerializedName(value="datapoints")
    private List<DataPoint> dataPoints = new ArrayList<DataPoint>();

    protected Metric(String name) {
        this.name = Preconditions.checkNotNullOrEmpty(name);
    }

    protected Metric(String name, String registeredType) {
        this(name);
        this.type = registeredType;
    }

    public Metric addTag(String name, String value) {
        Preconditions.checkNotNullOrEmpty(name);
        Preconditions.checkNotNullOrEmpty(value);
        this.tags.put(name, value);
        return this;
    }

    public Metric addTags(Map<String, String> tags) {
        com.google.common.base.Preconditions.checkNotNull(tags);
        tags.putAll(tags);
        return this;
    }

    public Metric addDataPoint(long timestamp, long value) {
        this.dataPoints.add(new DataPoint(timestamp, value));
        return this;
    }

    public Metric addDataPoint(long value) {
        return this.addDataPoint(System.currentTimeMillis(), value);
    }

    public Metric addDataPoint(long timestamp, Object value) {
        this.dataPoints.add(new DataPoint(timestamp, value));
        return this;
    }

    public Metric addDataPoint(long timestamp, double value) {
        this.dataPoints.add(new DataPoint(timestamp, value));
        return this;
    }

    public Metric addDataPoint(double value) {
        return this.addDataPoint(System.currentTimeMillis(), value);
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.dataPoints);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public String getType() {
        return this.type;
    }
}

