/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kairosdb.client.builder.QueryMetric;
import org.kairosdb.client.builder.RelativeTime;
import org.kairosdb.client.builder.TimeUnit;
import org.kairosdb.client.builder.TimeValidator;
import org.kairosdb.client.builder.aggregator.CustomAggregator;
import org.kairosdb.client.serializer.CustomAggregatorSerializer;
import org.kairosdb.client.serializer.ListMultiMapSerializer;
import org.kairosdb.client.serializer.OrderSerializer;
import org.kairosdb.client.util.Preconditions;

public class QueryBuilder {
    @SerializedName(value="start_absolute")
    private Long startAbsolute;
    @SerializedName(value="end_absolute")
    private Long endAbsolute;
    @SerializedName(value="start_relative")
    private RelativeTime startRelative;
    @SerializedName(value="end_relative")
    private RelativeTime endRelative;
    private int cacheTime;
    private List<QueryMetric> metrics = new ArrayList<QueryMetric>();
    private transient Gson mapper;

    private QueryBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(CustomAggregator.class, (Object)new CustomAggregatorSerializer());
        builder.registerTypeAdapter(ListMultimap.class, (Object)new ListMultiMapSerializer());
        builder.registerTypeAdapter(QueryMetric.Order.class, (Object)new OrderSerializer());
        this.mapper = builder.create();
    }

    public QueryBuilder setStart(Date start) {
        com.google.common.base.Preconditions.checkNotNull((Object)start);
        com.google.common.base.Preconditions.checkArgument((this.startRelative == null ? 1 : 0) != 0, (Object)"Both relative and absolute start times cannot be set.");
        this.startAbsolute = start.getTime();
        com.google.common.base.Preconditions.checkArgument((this.startAbsolute <= System.currentTimeMillis() ? 1 : 0) != 0, (Object)"Start time cannot be in the future.");
        return this;
    }

    public QueryBuilder setStart(int duration, TimeUnit unit) {
        com.google.common.base.Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0);
        com.google.common.base.Preconditions.checkNotNull((Object)((Object)unit));
        com.google.common.base.Preconditions.checkArgument((this.startAbsolute == null ? 1 : 0) != 0, (Object)"Both relative and absolute start times cannot be set.");
        this.startRelative = new RelativeTime(duration, unit);
        com.google.common.base.Preconditions.checkArgument((this.startRelative.getTimeRelativeTo(System.currentTimeMillis()) <= System.currentTimeMillis() ? 1 : 0) != 0, (Object)"Start time cannot be in the future.");
        return this;
    }

    public QueryBuilder setEnd(Date end) {
        com.google.common.base.Preconditions.checkArgument((this.endRelative == null ? 1 : 0) != 0, (Object)"Both relative and absolute end times cannot be set.");
        this.endAbsolute = end.getTime();
        return this;
    }

    public QueryBuilder setEnd(int duration, TimeUnit unit) {
        com.google.common.base.Preconditions.checkNotNull((Object)((Object)unit));
        com.google.common.base.Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0);
        com.google.common.base.Preconditions.checkArgument((this.endAbsolute == null ? 1 : 0) != 0, (Object)"Both relative and absolute end times cannot be set.");
        this.endRelative = new RelativeTime(duration, unit);
        return this;
    }

    public QueryBuilder setCacheTime(int cacheTime) {
        com.google.common.base.Preconditions.checkArgument((cacheTime > 0 ? 1 : 0) != 0, (Object)"Cache time must be greater than 0.");
        this.cacheTime = cacheTime;
        return this;
    }

    public static QueryBuilder getInstance() {
        return new QueryBuilder();
    }

    public QueryMetric addMetric(String name) {
        Preconditions.checkNotNullOrEmpty(name, "Name cannot be null or empty.", new Object[0]);
        QueryMetric metric = new QueryMetric(name);
        this.metrics.add(metric);
        return metric;
    }

    public Date getStartAbsolute() {
        return new Date(this.startAbsolute);
    }

    public Date getEndAbsolute() {
        return new Date(this.endAbsolute);
    }

    public RelativeTime getStartRelative() {
        return this.startRelative;
    }

    public RelativeTime getEndRelative() {
        return this.endRelative;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public List<QueryMetric> getMetrics() {
        return this.metrics;
    }

    public String build() throws IOException {
        this.validateTimes();
        return this.mapper.toJson((Object)this);
    }

    private void validateTimes() {
        com.google.common.base.Preconditions.checkState((this.startAbsolute != null || this.startRelative != null ? 1 : 0) != 0, (Object)"Start time must be specified");
        if (this.endAbsolute != null) {
            if (this.startAbsolute != null) {
                TimeValidator.validateEndTimeLaterThanStartTime((long)this.startAbsolute, (long)this.endAbsolute);
            } else {
                TimeValidator.validateEndTimeLaterThanStartTime(this.startRelative, (long)this.endAbsolute);
            }
        } else if (this.endRelative != null) {
            if (this.startAbsolute != null) {
                TimeValidator.validateEndTimeLaterThanStartTime((long)this.startAbsolute, this.endRelative);
            } else {
                TimeValidator.validateEndTimeLaterThanStartTime(this.startRelative, this.endRelative);
            }
        }
    }
}

