/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.kairosdb.client.builder.Aggregator;
import org.kairosdb.client.builder.Grouper;
import org.kairosdb.client.util.Preconditions;

public class QueryMetric {
    private final String name;
    private final ListMultimap<String, String> tags = ArrayListMultimap.create();
    @SerializedName(value="group_by")
    private final List<Grouper> groupers = new ArrayList<Grouper>();
    private final List<Aggregator> aggregators = new ArrayList<Aggregator>();
    private Integer limit;
    private Order order;

    QueryMetric(String name) {
        this.name = Preconditions.checkNotNullOrEmpty(name);
    }

    public QueryMetric addMultiValuedTags(Map<String, List<String>> tags) {
        com.google.common.base.Preconditions.checkNotNull(tags);
        for (String key : tags.keySet()) {
            this.tags.putAll((Object)key, (Iterable)tags.get(key));
        }
        return this;
    }

    public QueryMetric addTags(Map<String, String> tags) {
        com.google.common.base.Preconditions.checkNotNull(tags);
        for (String key : tags.keySet()) {
            this.tags.put((Object)key, (Object)tags.get(key));
        }
        return this;
    }

    public QueryMetric addTag(String name, String ... values) {
        Preconditions.checkNotNullOrEmpty(name);
        com.google.common.base.Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0);
        for (String value : values) {
            Preconditions.checkNotNullOrEmpty(value);
        }
        this.tags.putAll((Object)name, Arrays.asList(values));
        return this;
    }

    public QueryMetric addAggregator(Aggregator aggregator) {
        com.google.common.base.Preconditions.checkNotNull((Object)aggregator);
        this.aggregators.add(aggregator);
        return this;
    }

    public QueryMetric addGrouper(Grouper grouper) {
        com.google.common.base.Preconditions.checkNotNull((Object)grouper);
        this.groupers.add(grouper);
        return this;
    }

    public void setLimit(int limit) {
        com.google.common.base.Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be greater than 0");
        this.limit = limit;
    }

    public void setOrder(Order order) {
        com.google.common.base.Preconditions.checkNotNull((Object)((Object)order));
        this.order = order;
    }

    public static enum Order {
        ASCENDING("asc"),
        DESCENDING("desc");

        private String text;

        private Order(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

