/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.base.Preconditions;
import org.kairosdb.client.builder.RelativeTime;

public class TimeValidator {
    private TimeValidator() {
    }

    public static void validateEndTimeLaterThanStartTime(long startTime, long endTime) {
        Preconditions.checkState((endTime > startTime ? 1 : 0) != 0, (Object)"Start time cannot be later than the ending time");
    }

    public static void validateEndTimeLaterThanStartTime(RelativeTime startTime, RelativeTime endTime) {
        long now = System.currentTimeMillis();
        Preconditions.checkState((startTime.getTimeRelativeTo(now) < endTime.getTimeRelativeTo(now) ? 1 : 0) != 0, (Object)"Start time cannot be later than the ending time");
    }

    public static void validateEndTimeLaterThanStartTime(long startTime, RelativeTime endTime) {
        long now = System.currentTimeMillis();
        Preconditions.checkState((startTime < endTime.getTimeRelativeTo(now) ? 1 : 0) != 0, (Object)"Start time cannot be later than the ending time");
    }

    public static void validateEndTimeLaterThanStartTime(RelativeTime startTime, long endTime) {
        long now = System.currentTimeMillis();
        Preconditions.checkState((startTime.getTimeRelativeTo(now) < endTime ? 1 : 0) != 0, (Object)"Start time cannot be later than the ending time");
    }
}

