/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder.aggregator;

import com.google.common.base.Preconditions;
import org.kairosdb.client.builder.Aggregator;
import org.kairosdb.client.builder.TimeUnit;

public class SamplingAggregator
extends Aggregator {
    private Sampling sampling;

    public SamplingAggregator(String name, int value, TimeUnit unit) {
        super(name);
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"value must be greater than 0.");
        this.sampling = new Sampling(value, unit);
    }

    public int getValue() {
        return this.sampling.value;
    }

    public TimeUnit getUnit() {
        return this.sampling.unit;
    }

    private class Sampling {
        private int value;
        private TimeUnit unit;

        private Sampling(int value, TimeUnit unit) {
            this.value = value;
            this.unit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
        }
    }
}

