/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import org.kairosdb.client.response.GroupResult;
import org.kairosdb.client.response.grouping.DefaultGroupResult;
import org.kairosdb.client.response.grouping.TagGroupResult;
import org.kairosdb.client.response.grouping.TimeGroupResult;
import org.kairosdb.client.response.grouping.ValueGroupResult;

public class GroupByDeserializer
implements JsonDeserializer<GroupResult> {
    public GroupResult deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsGroupBy = jsonElement.getAsJsonObject();
        JsonElement nameElement = jsGroupBy.get("name");
        if (nameElement == null || nameElement.getAsString().isEmpty()) {
            throw new JsonParseException("name cannot be null");
        }
        String name = nameElement.getAsString();
        if (name.equals("type")) {
            return (GroupResult)jsonDeserializationContext.deserialize(jsonElement, DefaultGroupResult.class);
        }
        if (name.equals("tag")) {
            return (GroupResult)jsonDeserializationContext.deserialize(jsonElement, TagGroupResult.class);
        }
        if (name.equals("time")) {
            return (GroupResult)jsonDeserializationContext.deserialize(jsonElement, TimeGroupResult.class);
        }
        if (name.equals("value")) {
            return (GroupResult)jsonDeserializationContext.deserialize(jsonElement, ValueGroupResult.class);
        }
        throw new JsonParseException("Invalid group_by: " + name);
    }
}

