/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.function.Supplier;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.resource.AuthorizationResource;
import org.keycloak.authorization.client.resource.EntitlementResource;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.JsonSerialization;

public class AuthzClient {
    private final Http http;
    private Supplier<String> patSupplier;
    private final ServerConfiguration serverConfiguration;
    private final Configuration deployment;

    public static AuthzClient create() {
        InputStream configStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("keycloak.json");
        if (configStream == null) {
            throw new RuntimeException("Could not find any keycloak.json file in classpath.");
        }
        try {
            return AuthzClient.create((Configuration)((Object)JsonSerialization.readValue((InputStream)configStream, Configuration.class)));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse configuration.", e);
        }
    }

    public static AuthzClient create(Configuration configuration) {
        return new AuthzClient(configuration, configuration.getClientAuthenticator());
    }

    public static AuthzClient create(Configuration configuration, ClientAuthenticator authenticator) {
        return new AuthzClient(configuration, authenticator);
    }

    private AuthzClient(Configuration configuration, ClientAuthenticator authenticator) {
        if (configuration == null) {
            throw new IllegalArgumentException("Client configuration can not be null.");
        }
        String configurationUrl = configuration.getAuthServerUrl();
        if (configurationUrl == null) {
            throw new IllegalArgumentException("Configuration URL can not be null.");
        }
        configurationUrl = configurationUrl + "/realms/" + configuration.getRealm() + "/.well-known/uma-configuration";
        this.deployment = configuration;
        this.http = new Http(configuration, authenticator != null ? authenticator : configuration.getClientAuthenticator());
        try {
            this.serverConfiguration = this.http.get(URI.create(configurationUrl)).response().json(ServerConfiguration.class).execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain configuration from server [" + configurationUrl + "].", e);
        }
        this.http.setServerConfiguration(this.serverConfiguration);
    }

    private AuthzClient(Configuration configuration) {
        this(configuration, null);
    }

    public ProtectionResource protection() {
        return new ProtectionResource(this.http, this.createPatSupplier());
    }

    public AuthorizationResource authorization(String accesstoken) {
        return new AuthorizationResource(this.http, accesstoken);
    }

    public AuthorizationResource authorization(String userName, String password) {
        return new AuthorizationResource(this.http, this.obtainAccessToken(userName, password).getToken());
    }

    public EntitlementResource entitlement(String eat) {
        return new EntitlementResource(this.http, eat);
    }

    public AccessTokenResponse obtainAccessToken() {
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().client().response().json(AccessTokenResponse.class).execute();
    }

    public AccessTokenResponse obtainAccessToken(String userName, String password) {
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().oauth2ResourceOwnerPassword(userName, password).response().json(AccessTokenResponse.class).execute();
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public Configuration getConfiguration() {
        return this.deployment;
    }

    private Supplier<String> createPatSupplier() {
        if (this.patSupplier == null) {
            this.patSupplier = new Supplier<String>(){
                AccessTokenResponse clientToken;
                {
                    this.clientToken = AuthzClient.this.obtainAccessToken();
                }

                @Override
                public String get() {
                    String token = this.clientToken.getToken();
                    try {
                        AccessToken accessToken = (AccessToken)JsonSerialization.readValue((byte[])new JWSInput(token).getContent(), AccessToken.class);
                        if (accessToken.isActive()) {
                            return token;
                        }
                        this.clientToken = AuthzClient.this.http.post(AuthzClient.this.serverConfiguration.getTokenEndpoint()).authentication().client().form().param("grant_type", "refresh_token").param("refresh_token", this.clientToken.getRefreshToken()).response().json(AccessTokenResponse.class).execute();
                    }
                    catch (Exception e) {
                        AuthzClient.this.patSupplier = null;
                        throw new RuntimeException(e);
                    }
                    return this.clientToken.getToken();
                }
            };
        }
        return this.patSupplier;
    }
}

