/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.authorization.client.util.HttpMethod;

public class HttpMethodAuthenticator<R> {
    private final HttpMethod<R> method;
    private final ClientAuthenticator authenticator;

    public HttpMethodAuthenticator(HttpMethod<R> method, ClientAuthenticator authenticator) {
        this.method = method;
        this.authenticator = authenticator;
    }

    public HttpMethod<R> client() {
        this.method.params.put("grant_type", "client_credentials");
        this.authenticator.configureClientCredentials(this.method.params, this.method.headers);
        return this.method;
    }

    public HttpMethod<R> oauth2ResourceOwnerPassword(String userName, String password) {
        this.client();
        this.method.params.put("grant_type", "password");
        this.method.params.put("username", userName);
        this.method.params.put("password", password);
        return this.method;
    }
}

