/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.math.BigInteger;
import java.util.Arrays;

public class JWKUtil {
    public static byte[] toIntegerBytes(BigInteger bigInt) {
        return JWKUtil.toIntegerBytes(bigInt, bigInt.bitLength());
    }

    public static byte[] toIntegerBytes(BigInteger bigInt, int bitlen) {
        assert (bigInt.bitLength() <= bitlen) : "Incorrect big integer with bit length " + bigInt.bitLength() + " for " + bitlen;
        int bytelen = (bitlen + 7) / 8;
        byte[] array = bigInt.toByteArray();
        if (array.length == bytelen) {
            return array;
        }
        if (bytelen < array.length) {
            return Arrays.copyOfRange(array, array.length - bytelen, array.length);
        }
        byte[] resizedBytes = new byte[bytelen];
        System.arraycopy(array, 0, resizedBytes, bytelen - array.length, array.length);
        return resizedBytes;
    }
}

