/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.Permission;

public class AuthorizationContext {
    private final AccessToken authzToken;
    private final Map<String, PolicyEnforcerConfig.PathConfig> paths;
    private boolean granted;

    public AuthorizationContext(AccessToken authzToken, Map<String, PolicyEnforcerConfig.PathConfig> paths) {
        this.authzToken = authzToken;
        this.paths = paths;
        this.granted = true;
    }

    public AuthorizationContext() {
        this(null, null);
        this.granted = false;
    }

    public boolean hasPermission(String resourceName, String scopeName) {
        if (this.authzToken == null) {
            return false;
        }
        AccessToken.Authorization authorization = this.authzToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        for (Permission permission : authorization.getPermissions()) {
            for (PolicyEnforcerConfig.PathConfig pathHolder : this.paths.values()) {
                if (!pathHolder.getName().equals(resourceName) || !pathHolder.getId().equals(permission.getResourceSetId()) || !permission.getScopes().contains(scopeName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasResourcePermission(String resourceName) {
        if (this.authzToken == null) {
            return false;
        }
        AccessToken.Authorization authorization = this.authzToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        for (Permission permission : authorization.getPermissions()) {
            for (PolicyEnforcerConfig.PathConfig pathHolder : this.paths.values()) {
                if (!pathHolder.getName().equals(resourceName) || !pathHolder.getId().equals(permission.getResourceSetId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasScopePermission(String scopeName) {
        if (this.authzToken == null) {
            return false;
        }
        AccessToken.Authorization authorization = this.authzToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        for (Permission permission : authorization.getPermissions()) {
            if (!permission.getScopes().contains(scopeName)) continue;
            return true;
        }
        return false;
    }

    public List<Permission> getPermissions() {
        if (this.authzToken == null) {
            return Collections.emptyList();
        }
        AccessToken.Authorization authorization = this.authzToken.getAuthorization();
        if (authorization == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(authorization.getPermissions());
    }

    public boolean isGranted() {
        return this.granted;
    }
}

