/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.KerberosFederationProvider;
import org.keycloak.federation.kerberos.impl.KerberosServerSubjectAuthenticator;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.utils.CredentialHelper;

public class KerberosFederationProviderFactory
implements UserStorageProviderFactory<KerberosFederationProvider> {
    private static final Logger logger = Logger.getLogger(KerberosFederationProviderFactory.class);
    public static final String PROVIDER_NAME = "kerberos";
    protected static final List<ProviderConfigProperty> configProperties = KerberosFederationProviderFactory.getConfigProps();

    public KerberosFederationProvider create(KeycloakSession session, ComponentModel model) {
        return new KerberosFederationProvider(session, new UserStorageProviderModel(model), this);
    }

    public String getId() {
        return PROVIDER_NAME;
    }

    private static List<ProviderConfigProperty> getConfigProps() {
        return ProviderConfigurationBuilder.create().property().name("kerberosRealm").label("kerberos-realm").helpText("kerberos-realm.tooltip").type("String").add().property().name("serverPrincipal").label("server-principal").helpText("server-principal.tooltip").type("String").add().property().name("keyTab").label("keytab").helpText("keytab.tooltip").type("String").add().property().name("debug").label("debug").helpText("debug.tooltip").type("boolean").defaultValue((Object)"false").add().property().name("allowPasswordAuthentication").label("allow-password-authentication").helpText("allow-password-authentication.tooltip").type("boolean").defaultValue((Object)"false").add().property().name("editMode").label("edit-mode").helpText("edit-mode.tooltip").type("List").options(new String[]{UserStorageProvider.EditMode.READ_ONLY.toString(), UserStorageProvider.EditMode.UNSYNCED.toString()}).add().property().name("updateProfileFirstLogin").label("update-profile-first-login").helpText("update-profile-first-login.tooltip").type("boolean").defaultValue((Object)"false").add().build();
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    protected SPNEGOAuthenticator createSPNEGOAuthenticator(String spnegoToken, CommonKerberosConfig kerberosConfig) {
        KerberosServerSubjectAuthenticator kerberosAuth = this.createKerberosSubjectAuthenticator(kerberosConfig);
        return new SPNEGOAuthenticator(kerberosConfig, kerberosAuth, spnegoToken);
    }

    protected KerberosServerSubjectAuthenticator createKerberosSubjectAuthenticator(CommonKerberosConfig kerberosConfig) {
        return new KerberosServerSubjectAuthenticator(kerberosConfig);
    }

    protected KerberosUsernamePasswordAuthenticator createKerberosUsernamePasswordAuthenticator(CommonKerberosConfig kerberosConfig) {
        return new KerberosUsernamePasswordAuthenticator(kerberosConfig);
    }

    public void onCreate(KeycloakSession session, RealmModel realm, ComponentModel model) {
        CredentialHelper.setOrReplaceAuthenticationRequirement((KeycloakSession)session, (RealmModel)realm, (String)PROVIDER_NAME, (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.ALTERNATIVE, (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.DISABLED);
    }

    public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        CredentialHelper.setOrReplaceAuthenticationRequirement((KeycloakSession)session, (RealmModel)realm, (String)PROVIDER_NAME, (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.ALTERNATIVE, (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.DISABLED);
    }

    public void preRemove(KeycloakSession session, RealmModel realm, ComponentModel model) {
        CredentialHelper.setOrReplaceAuthenticationRequirement((KeycloakSession)session, (RealmModel)realm, (String)PROVIDER_NAME, (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.DISABLED, null);
    }
}

