/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class ResourceServerRemovedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String clientId;

    public static ResourceServerRemovedEvent create(String id, String clientId) {
        ResourceServerRemovedEvent event = new ResourceServerRemovedEvent();
        event.id = id;
        event.clientId = clientId;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.format("ResourceServerRemovedEvent [ id=%s, clientId=%s ]", this.id, this.clientId);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.resourceServerRemoval(this.id, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<ResourceServerRemovedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ResourceServerRemovedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.id, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.clientId, (ObjectOutput)output);
        }

        public ResourceServerRemovedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ResourceServerRemovedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ResourceServerRemovedEvent res = new ResourceServerRemovedEvent();
            res.id = MarshallUtil.unmarshallString((ObjectInput)input);
            res.clientId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

