/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote.transaction;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.ClientSessionQueryConditionalRemover;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.UserSessionQueryConditionalRemover;
import org.keycloak.models.sessions.infinispan.remote.transaction.ClientSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.UserSessionChangeLogTransaction;

public class UserSessionTransaction
extends AbstractKeycloakTransaction {
    private final UserSessionChangeLogTransaction userSessions;
    private final ClientSessionChangeLogTransaction clientSessions;
    private final UserSessionChangeLogTransaction offlineUserSessions;
    private final ClientSessionChangeLogTransaction offlineClientSessions;

    public UserSessionTransaction(UserSessionChangeLogTransaction userSessions, UserSessionChangeLogTransaction offlineUserSessions, ClientSessionChangeLogTransaction clientSessions, ClientSessionChangeLogTransaction offlineClientSessions) {
        this.userSessions = userSessions;
        this.offlineUserSessions = offlineUserSessions;
        this.clientSessions = clientSessions;
        this.offlineClientSessions = offlineClientSessions;
    }

    public void begin() {
        super.begin();
        this.userSessions.begin();
        this.clientSessions.begin();
        this.offlineUserSessions.begin();
        this.offlineClientSessions.begin();
    }

    protected void commitImpl() {
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
        this.userSessions.commitAsync((AggregateCompletionStage<Void>)stage);
        this.clientSessions.commitAsync((AggregateCompletionStage<Void>)stage);
        this.offlineUserSessions.commitAsync((AggregateCompletionStage<Void>)stage);
        this.offlineClientSessions.commitAsync((AggregateCompletionStage<Void>)stage);
        CompletionStages.join((CompletionStage)stage.freeze());
    }

    protected void rollbackImpl() {
        this.userSessions.rollback();
        this.clientSessions.rollback();
        this.offlineUserSessions.rollback();
        this.offlineClientSessions.rollback();
    }

    public ClientSessionChangeLogTransaction getClientSessions(boolean offline) {
        return offline ? this.offlineClientSessions : this.clientSessions;
    }

    public UserSessionChangeLogTransaction getUserSessions(boolean offline) {
        return offline ? this.offlineUserSessions : this.userSessions;
    }

    public void removeAllSessionsByRealmId(String realmId) {
        ((ClientSessionQueryConditionalRemover)this.clientSessions.getConditionalRemover()).removeByRealmId(realmId);
        ((UserSessionQueryConditionalRemover)this.userSessions.getConditionalRemover()).removeByRealmId(realmId);
        ((ClientSessionQueryConditionalRemover)this.offlineClientSessions.getConditionalRemover()).removeByRealmId(realmId);
        ((UserSessionQueryConditionalRemover)this.offlineUserSessions.getConditionalRemover()).removeByRealmId(realmId);
    }

    public void removeOnlineSessionsByRealmId(String realmId) {
        ((ClientSessionQueryConditionalRemover)this.clientSessions.getConditionalRemover()).removeByRealmId(realmId);
        ((UserSessionQueryConditionalRemover)this.userSessions.getConditionalRemover()).removeByRealmId(realmId);
    }

    public void removeAllSessionByUserId(String realmId, String userId) {
        ((UserSessionQueryConditionalRemover)this.userSessions.getConditionalRemover()).removeByUserId(realmId, userId);
        ((ClientSessionQueryConditionalRemover)this.clientSessions.getConditionalRemover()).removeByUserId(realmId, userId);
    }

    public void removeUserSessionById(String userSessionId, boolean offline) {
        this.getUserSessions(offline).remove(userSessionId);
        this.getClientSessions(offline).removeByUserSessionId(userSessionId);
    }
}

