/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.models.ClientModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.IckleQueryMapModelCriteriaBuilder;
import org.keycloak.models.map.storage.hotRod.IckleQueryOperators;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.storage.StorageId;

public class IckleQueryWhereClauses {
    private static final Map<SearchableModelField<?>, WhereClauseProducer> WHERE_CLAUSE_PRODUCER_OVERRIDES = new HashMap();

    private static String produceWhereClause(String modelFieldName, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        return IckleQueryOperators.combineExpressions(op, modelFieldName, values, parameters);
    }

    private static WhereClauseProducer whereClauseProducerForModelField(SearchableModelField<?> modelField) {
        return WHERE_CLAUSE_PRODUCER_OVERRIDES.getOrDefault(modelField, IckleQueryWhereClauses::produceWhereClause);
    }

    public static String produceWhereClause(SearchableModelField<?> modelField, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        String fieldName = IckleQueryMapModelCriteriaBuilder.getFieldName(modelField);
        if (IckleQueryMapModelCriteriaBuilder.isAnalyzedModelField(modelField) && (op.equals((Object)ModelCriteriaBuilder.Operator.ILIKE) || op.equals((Object)ModelCriteriaBuilder.Operator.EQ) || op.equals((Object)ModelCriteriaBuilder.Operator.NE))) {
            String clause = "c." + fieldName + " : '" + IckleQueryMapModelCriteriaBuilder.sanitizeAnalyzed(((String)values[0]).toLowerCase()) + "'";
            if (op.equals((Object)ModelCriteriaBuilder.Operator.NE)) {
                return "not(" + clause + ")";
            }
            return clause;
        }
        return IckleQueryWhereClauses.whereClauseProducerForModelField(modelField).produceWhereClause(fieldName, op, values, parameters);
    }

    private static String whereClauseForAttributes(String modelFieldName, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        if (values == null || values.length != 2) {
            throw new CriterionNotSupportedException(ClientModel.SearchableFields.ATTRIBUTE, op, "Invalid arguments, expected attribute_name-value pair, got: " + Arrays.toString(values));
        }
        Object attrName = values[0];
        if (!(attrName instanceof String)) {
            throw new CriterionNotSupportedException(ClientModel.SearchableFields.ATTRIBUTE, op, "Invalid arguments, expected (String attribute_name), got: " + Arrays.toString(values));
        }
        String attrNameS = (String)attrName;
        Object[] realValues = new Object[values.length - 1];
        System.arraycopy(values, 1, realValues, 0, values.length - 1);
        String nameClause = IckleQueryOperators.combineExpressions(ModelCriteriaBuilder.Operator.EQ, modelFieldName + ".name", new Object[]{attrNameS}, parameters);
        String valueClause = IckleQueryOperators.combineExpressions(op, modelFieldName + ".values", realValues, parameters);
        return "(" + nameClause + ") AND (" + valueClause + ")";
    }

    private static String whereClauseForUserIdpAlias(String modelFieldName, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        if (op != ModelCriteriaBuilder.Operator.EQ) {
            throw new CriterionNotSupportedException(UserModel.SearchableFields.IDP_AND_USER, op);
        }
        if (values == null || values.length == 0 || values.length > 2) {
            throw new CriterionNotSupportedException(UserModel.SearchableFields.IDP_AND_USER, op, "Invalid arguments, expected (idp_alias) or (idp_alias, idp_user), got: " + Arrays.toString(values));
        }
        Object idpAlias = values[0];
        if (values.length == 1) {
            return IckleQueryOperators.combineExpressions(op, modelFieldName + ".identityProvider", values, parameters);
        }
        if (idpAlias == null) {
            Object idpUserId = values[1];
            return IckleQueryOperators.combineExpressions(op, modelFieldName + ".userId", new Object[]{idpUserId}, parameters);
        }
        Object idpUserId = values[1];
        String idClause = IckleQueryOperators.combineExpressions(op, modelFieldName + ".identityProvider", new Object[]{idpAlias}, parameters);
        String userIdClause = IckleQueryOperators.combineExpressions(op, modelFieldName + ".userId", new Object[]{idpUserId}, parameters);
        return "(" + idClause + ") AND (" + userIdClause + ")";
    }

    private static String whereClauseForConsentClientFederationLink(String modelFieldName, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        if (op != ModelCriteriaBuilder.Operator.EQ) {
            throw new CriterionNotSupportedException(UserModel.SearchableFields.CONSENT_CLIENT_FEDERATION_LINK, op);
        }
        if (values == null || values.length != 1) {
            throw new CriterionNotSupportedException(UserModel.SearchableFields.CONSENT_CLIENT_FEDERATION_LINK, op, "Invalid arguments, expected (federation_provider_id), got: " + Arrays.toString(values));
        }
        String providerId = new StorageId((String)values[0], "").getId();
        return IckleQueryOperators.combineExpressions(ModelCriteriaBuilder.Operator.LIKE, IckleQueryMapModelCriteriaBuilder.getFieldName(UserModel.SearchableFields.CONSENT_FOR_CLIENT), new String[]{providerId + "%"}, parameters);
    }

    private static String whereClauseForCorrespondingSessionId(String modelFieldName, ModelCriteriaBuilder.Operator op, Object[] values, Map<String, Object> parameters) {
        if (op != ModelCriteriaBuilder.Operator.EQ) {
            throw new CriterionNotSupportedException(UserSessionModel.SearchableFields.CORRESPONDING_SESSION_ID, op);
        }
        if (values == null || values.length != 1) {
            throw new CriterionNotSupportedException(UserSessionModel.SearchableFields.CORRESPONDING_SESSION_ID, op, "Invalid arguments, expected (corresponding_session:id), got: " + Arrays.toString(values));
        }
        String nameClause = IckleQueryOperators.combineExpressions(op, "notes.key", new String[]{"correspondingSessionId"}, parameters);
        String valueClause = IckleQueryOperators.combineExpressions(op, "notes.value", values, parameters);
        return "(" + nameClause + ") AND (" + valueClause + ")";
    }

    static {
        WHERE_CLAUSE_PRODUCER_OVERRIDES.put(ClientModel.SearchableFields.ATTRIBUTE, IckleQueryWhereClauses::whereClauseForAttributes);
        WHERE_CLAUSE_PRODUCER_OVERRIDES.put(UserModel.SearchableFields.ATTRIBUTE, IckleQueryWhereClauses::whereClauseForAttributes);
        WHERE_CLAUSE_PRODUCER_OVERRIDES.put(UserModel.SearchableFields.IDP_AND_USER, IckleQueryWhereClauses::whereClauseForUserIdpAlias);
        WHERE_CLAUSE_PRODUCER_OVERRIDES.put(UserModel.SearchableFields.CONSENT_CLIENT_FEDERATION_LINK, IckleQueryWhereClauses::whereClauseForConsentClientFederationLink);
        WHERE_CLAUSE_PRODUCER_OVERRIDES.put(UserSessionModel.SearchableFields.CORRESPONDING_SESSION_ID, IckleQueryWhereClauses::whereClauseForCorrespondingSessionId);
    }

    @FunctionalInterface
    private static interface WhereClauseProducer {
        public String produceWhereClause(String var1, ModelCriteriaBuilder.Operator var2, Object[] var3, Map<String, Object> var4);
    }
}

