/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.connections;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.storage.hotRod.HotRodMapStorageProviderFactory;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDescriptor;
import org.keycloak.models.map.storage.hotRod.common.HotRodUtils;
import org.keycloak.models.map.storage.hotRod.common.ProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.connections.DefaultHotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProvider;
import org.keycloak.models.map.storage.hotRod.connections.HotRodConnectionProviderFactory;

public class DefaultHotRodConnectionProviderFactory
implements HotRodConnectionProviderFactory {
    public static final String PROVIDER_ID = "default";
    private static final Logger LOG = Logger.getLogger(DefaultHotRodConnectionProviderFactory.class);
    private Config.Scope config;
    private RemoteCacheManager remoteCacheManager;

    public HotRodConnectionProvider create(KeycloakSession session) {
        if (this.remoteCacheManager == null) {
            this.lazyInit();
        }
        return new DefaultHotRodConnectionProvider(this.remoteCacheManager);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void lazyInit() {
        boolean configureRemoteCaches;
        if (this.config.getBoolean("embedded", Boolean.valueOf(false)).booleanValue()) {
            HotRodUtils.createHotRodMapStoreServer(this.config.getInt("embeddedPort", Integer.valueOf(11444)));
        }
        ConfigurationBuilder remoteBuilder = new ConfigurationBuilder();
        remoteBuilder.addServer().host(this.config.get("host", "localhost")).port(this.config.getInt("port", Integer.valueOf(11444)).intValue()).clientIntelligence(ClientIntelligence.HASH_DISTRIBUTION_AWARE).marshaller((Marshaller)new ProtoStreamMarshaller());
        if (this.config.getBoolean("enableSecurity", Boolean.valueOf(true)).booleanValue()) {
            remoteBuilder.security().authentication().saslMechanism("SCRAM-SHA-512").username(this.config.get("username", "admin")).password(this.config.get("password", "admin")).realm(this.config.get("realm", PROVIDER_ID));
        }
        if (configureRemoteCaches = this.config.getBoolean("configureRemoteCaches", Boolean.valueOf(false)).booleanValue()) {
            this.configureRemoteCaches(remoteBuilder);
        }
        remoteBuilder.addContextInitializer((SerializationContextInitializer)ProtoSchemaInitializer.INSTANCE);
        this.remoteCacheManager = new RemoteCacheManager(remoteBuilder.build());
        Set<String> remoteCaches = HotRodMapStorageProviderFactory.ENTITY_DESCRIPTOR_MAP.values().stream().map(HotRodEntityDescriptor::getCacheName).collect(Collectors.toSet());
        if (configureRemoteCaches) {
            remoteCaches.forEach(arg_0 -> ((RemoteCacheManager)this.remoteCacheManager).getCache(arg_0));
        }
        this.registerSchemata(ProtoSchemaInitializer.INSTANCE);
        RemoteCacheManagerAdmin administration = this.remoteCacheManager.administration();
        if (this.config.getBoolean("reindexAllCaches", Boolean.valueOf(false)).booleanValue()) {
            LOG.infof("Reindexing all caches. This can take a long time to complete. While the rebuild operation is in progress, queries might return fewer results.", new Object[0]);
            remoteCaches.forEach(arg_0 -> ((RemoteCacheManagerAdmin)administration).reindexCache(arg_0));
        } else {
            String reindexCaches = this.config.get("reindexCaches", "");
            if (reindexCaches != null) {
                Arrays.stream(reindexCaches.split(",")).map(String::trim).filter(e -> !e.isEmpty()).filter(remoteCaches::contains).peek(cacheName -> LOG.infof("Reindexing %s cache. This can take a long time to complete. While the rebuild operation is in progress, queries might return fewer results.", cacheName)).forEach(arg_0 -> ((RemoteCacheManagerAdmin)administration).reindexCache(arg_0));
            }
        }
    }

    private void registerSchemata(GeneratedSchema initializer) {
        RemoteCache protoMetadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        protoMetadataCache.put((Object)initializer.getProtoFileName(), (Object)initializer.getProtoFile());
        String errors = (String)protoMetadataCache.get((Object)".errors");
        if (errors != null) {
            throw new IllegalStateException("Some Protobuf schema files contain errors: " + errors + "\nSchema :\n" + initializer.getProtoFileName());
        }
    }

    private void configureRemoteCaches(ConfigurationBuilder builder) {
        URI uri;
        try {
            uri = DefaultHotRodConnectionProviderFactory.class.getClassLoader().getResource("config/cacheConfig.xml").toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot read the cache configuration!", e);
        }
        HotRodMapStorageProviderFactory.ENTITY_DESCRIPTOR_MAP.values().stream().map(HotRodEntityDescriptor::getCacheName).forEach(name -> builder.remoteCache(name).configurationURI(uri));
    }
}

