/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.userSession;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.common.HotRodStringPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodSessionState;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodUserSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

public class HotRodUserSessionEntityDelegate
extends HotRodUserSessionEntity.AbstractHotRodUserSessionEntityDelegate
implements MapUserSessionEntity {
    private final HotRodUserSessionEntity hotRodEntity;

    public HotRodUserSessionEntityDelegate() {
        this.hotRodEntity = new HotRodUserSessionEntity();
    }

    public HotRodUserSessionEntityDelegate(HotRodUserSessionEntity hotRodEntity) {
        this.hotRodEntity = hotRodEntity;
    }

    public HotRodUserSessionEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodUserSessionEntity();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodUserSessionEntityDelegate)) {
            return false;
        }
        HotRodUserSessionEntityDelegate other = (HotRodUserSessionEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAuthMethod(), other.getAuthMethod()) && Objects.equals(this.getAuthenticatedClientSessions(), other.getAuthenticatedClientSessions()) && Objects.equals(this.getBrokerSessionId(), other.getBrokerSessionId()) && Objects.equals(this.getBrokerUserId(), other.getBrokerUserId()) && Objects.equals(this.getExpiration(), other.getExpiration()) && Objects.equals(this.getIpAddress(), other.getIpAddress()) && Objects.equals(this.getLastSessionRefresh(), other.getLastSessionRefresh()) && Objects.equals(this.getLoginUsername(), other.getLoginUsername()) && Objects.equals(this.getNotes(), other.getNotes()) && Objects.equals(this.getPersistenceState(), other.getPersistenceState()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getStarted(), other.getStarted()) && Objects.equals(this.getState(), other.getState()) && Objects.equals(this.getUserId(), other.getUserId()) && Objects.equals(this.isOffline(), other.isOffline()) && Objects.equals(this.isRememberMe(), other.isRememberMe());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodUserSessionEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodUserSessionEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodUserSessionEntity e1 = (HotRodUserSessionEntity)o1;
        HotRodUserSessionEntity e2 = (HotRodUserSessionEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.userId, e2.userId) && Objects.equals(e1.brokerSessionId, e2.brokerSessionId) && Objects.equals(e1.brokerUserId, e2.brokerUserId) && Objects.equals(e1.loginUsername, e2.loginUsername) && Objects.equals(e1.ipAddress, e2.ipAddress) && Objects.equals(e1.authMethod, e2.authMethod) && Objects.equals(e1.rememberMe, e2.rememberMe) && Objects.equals(e1.started, e2.started) && Objects.equals(e1.lastSessionRefresh, e2.lastSessionRefresh) && Objects.equals(e1.expiration, e2.expiration) && Objects.equals(e1.notes, e2.notes) && Objects.equals((Object)e1.state, (Object)e2.state) && Objects.equals(e1.authenticatedClientSessions, e2.authenticatedClientSessions) && Objects.equals(e1.offline, e2.offline);
    }

    public static int entityHashCode(HotRodUserSessionEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public String getAuthMethod() {
        return this.hotRodEntity.authMethod == null ? null : this.hotRodEntity.authMethod;
    }

    public void setAuthMethod(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.authMethod, migrated);
        this.hotRodEntity.authMethod = migrated;
    }

    public String getAuthenticatedClientSession(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.authenticatedClientSessions, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setAuthenticatedClientSession(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.authenticatedClientSessions == null && !valueUndefined) {
            this.hotRodEntity.authenticatedClientSessions = new HashSet<HotRodStringPair>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.authenticatedClientSessions, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.authenticatedClientSessions.add(new HotRodStringPair(p0, p1)));
    }

    public Boolean removeAuthenticatedClientSession(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.authenticatedClientSessions, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public void setAuthenticatedClientSessions(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodStringPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodStringPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.authenticatedClientSessions, migrated);
        this.hotRodEntity.authenticatedClientSessions = migrated;
    }

    public Map<String, String> getAuthenticatedClientSessions() {
        return this.hotRodEntity.authenticatedClientSessions == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.authenticatedClientSessions, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public String getBrokerSessionId() {
        return this.hotRodEntity.brokerSessionId == null ? null : this.hotRodEntity.brokerSessionId;
    }

    public void setBrokerSessionId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.brokerSessionId, migrated);
        this.hotRodEntity.brokerSessionId = migrated;
    }

    public void setBrokerUserId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.brokerUserId, migrated);
        this.hotRodEntity.brokerUserId = migrated;
    }

    public String getBrokerUserId() {
        return this.hotRodEntity.brokerUserId == null ? null : this.hotRodEntity.brokerUserId;
    }

    public void setExpiration(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.expiration, migrated);
        this.hotRodEntity.expiration = migrated;
    }

    public Long getExpiration() {
        return this.hotRodEntity.expiration == null ? null : this.hotRodEntity.expiration;
    }

    public String getIpAddress() {
        return this.hotRodEntity.ipAddress == null ? null : this.hotRodEntity.ipAddress;
    }

    public void setIpAddress(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.ipAddress, migrated);
        this.hotRodEntity.ipAddress = migrated;
    }

    public Long getLastSessionRefresh() {
        return this.hotRodEntity.lastSessionRefresh == null ? null : this.hotRodEntity.lastSessionRefresh;
    }

    public void setLastSessionRefresh(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.lastSessionRefresh, migrated);
        this.hotRodEntity.lastSessionRefresh = migrated;
    }

    public String getLoginUsername() {
        return this.hotRodEntity.loginUsername == null ? null : this.hotRodEntity.loginUsername;
    }

    public void setLoginUsername(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.loginUsername, migrated);
        this.hotRodEntity.loginUsername = migrated;
    }

    public Boolean removeNote(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.notes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public void setNote(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.notes == null && !valueUndefined) {
            this.hotRodEntity.notes = new HashSet<HotRodStringPair>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.notes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.notes.add(new HotRodStringPair(p0, p1)));
    }

    public void setNotes(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodStringPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodStringPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.notes, migrated);
        this.hotRodEntity.notes = migrated;
    }

    public String getNote(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.notes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public Map<String, String> getNotes() {
        return this.hotRodEntity.notes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.notes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setOffline(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.offline, migrated);
        this.hotRodEntity.offline = migrated;
    }

    public Boolean isOffline() {
        return this.hotRodEntity.offline == null ? null : this.hotRodEntity.offline;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public Boolean isRememberMe() {
        return this.hotRodEntity.rememberMe == null ? null : this.hotRodEntity.rememberMe;
    }

    public void setRememberMe(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.rememberMe, migrated);
        this.hotRodEntity.rememberMe = migrated;
    }

    public Long getStarted() {
        return this.hotRodEntity.started == null ? null : this.hotRodEntity.started;
    }

    public void setStarted(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.started, migrated);
        this.hotRodEntity.started = migrated;
    }

    public void setState(UserSessionModel.State p0) {
        HotRodSessionState migrated = p0 == null ? null : HotRodTypesUtils.migrateStateToHotRodSessionState(p0);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals((Object)this.hotRodEntity.state, (Object)migrated);
        this.hotRodEntity.state = migrated;
    }

    public UserSessionModel.State getState() {
        return this.hotRodEntity.state == null ? null : HotRodTypesUtils.migrateHotRodSessionStateToState(this.hotRodEntity.state);
    }

    public void setUserId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.userId, migrated);
        this.hotRodEntity.userId = migrated;
    }

    public String getUserId() {
        return this.hotRodEntity.userId == null ? null : this.hotRodEntity.userId;
    }

    @Override
    public HotRodUserSessionEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

