/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.client;

import java.util.function.BiFunction;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.models.ClientModel;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.storage.SearchableModelField;

public class JpaClientModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaClientEntity, ClientModel, JpaClientModelCriteriaBuilder> {
    public JpaClientModelCriteriaBuilder() {
        super(JpaClientModelCriteriaBuilder::new);
    }

    private JpaClientModelCriteriaBuilder(BiFunction<CriteriaBuilder, Root<JpaClientEntity>, Predicate> predicateFunc) {
        super(JpaClientModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaClientModelCriteriaBuilder compare(SearchableModelField<? super ClientModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField.equals((Object)ClientModel.SearchableFields.REALM_ID) || modelField.equals((Object)ClientModel.SearchableFields.CLIENT_ID)) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaClientModelCriteriaBuilder((cb, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField.equals((Object)ClientModel.SearchableFields.ENABLED)) {
                    this.validateValue(value, modelField, op, Boolean.class);
                    return new JpaClientModelCriteriaBuilder((cb, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField.equals((Object)ClientModel.SearchableFields.SCOPE_MAPPING_ROLE)) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaClientModelCriteriaBuilder((cb, root) -> cb.isTrue(cb.function("@>", Boolean.TYPE, new Expression[]{cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fScopeMappings")}), cb.literal((Object)this.convertToJson(value[0]))})));
                }
                if (modelField.equals((Object)ClientModel.SearchableFields.ALWAYS_DISPLAY_IN_CONSOLE)) {
                    this.validateValue(value, modelField, op, Boolean.class);
                    return new JpaClientModelCriteriaBuilder((cb, root) -> cb.equal(cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fAlwaysDisplayInConsole")}), cb.literal((Object)this.convertToJson(value[0]))));
                }
                if (modelField.equals((Object)ClientModel.SearchableFields.ATTRIBUTE)) {
                    this.validateValue(value, modelField, op, String.class, String.class);
                    return new JpaClientModelCriteriaBuilder((cb, root) -> {
                        Join join = root.join("attributes");
                        return cb.and((Expression)cb.equal((Expression)join.get("name"), value[0]), (Expression)cb.equal((Expression)join.get("value"), value[1]));
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (!modelField.equals((Object)ClientModel.SearchableFields.CLIENT_ID)) break;
                this.validateValue(value, modelField, op, String.class);
                return new JpaClientModelCriteriaBuilder((cb, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

