/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.models.GroupModel;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.group.entity.JpaGroupEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.storage.SearchableModelField;

public class JpaGroupModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaGroupEntity, GroupModel, JpaGroupModelCriteriaBuilder> {
    public JpaGroupModelCriteriaBuilder() {
        super(JpaGroupModelCriteriaBuilder::new);
    }

    private JpaGroupModelCriteriaBuilder(BiFunction<CriteriaBuilder, Root<JpaGroupEntity>, Predicate> predicateFunc) {
        super(JpaGroupModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaGroupModelCriteriaBuilder compare(SearchableModelField<? super GroupModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField.equals((Object)GroupModel.SearchableFields.REALM_ID) || modelField.equals((Object)GroupModel.SearchableFields.NAME)) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField.equals((Object)GroupModel.SearchableFields.PARENT_ID)) {
                    if (value.length == 1 && Objects.isNull(value[0])) {
                        return new JpaGroupModelCriteriaBuilder((cb, root) -> cb.isNull((Expression)root.get("parentId")));
                    }
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, root) -> cb.equal((Expression)root.get("parentId"), value[0]));
                }
                if (modelField.equals((Object)GroupModel.SearchableFields.ASSIGNED_ROLE)) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, root) -> cb.isTrue(cb.function("@>", Boolean.TYPE, new Expression[]{cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fGrantedRoles")}), cb.literal((Object)this.convertToJson(value[0]))})));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField.equals((Object)GroupModel.SearchableFields.ID)) {
                    Collection<Object> collectionValues;
                    if (value == null || value.length == 0) {
                        throw new CriterionNotSupportedException(modelField, op);
                    }
                    if (value.length == 1) {
                        if (value[0] instanceof Object[]) {
                            collectionValues = Arrays.asList(value[0]);
                        } else if (value[0] instanceof Collection) {
                            collectionValues = (Collection)value[0];
                        } else if (value[0] instanceof Stream) {
                            try (Stream str = (Stream)value[0];){
                                collectionValues = str.collect(Collectors.toCollection(ArrayList::new));
                            }
                        } else {
                            collectionValues = Collections.singleton(value[0]);
                        }
                    } else {
                        collectionValues = new HashSet<Object>(Arrays.asList(value));
                    }
                    if (collectionValues.isEmpty()) {
                        return new JpaGroupModelCriteriaBuilder((cb, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaGroupModelCriteriaBuilder((cb, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("id"));
                        for (Object id : collectionValues) {
                            try {
                                in.value((Object)StringKeyConverter.UUIDKey.INSTANCE.fromString(Objects.toString(id, null)));
                            }
                            catch (IllegalArgumentException e) {
                                throw new CriterionNotSupportedException(modelField, op, id + " id is not in uuid format.", (Throwable)e);
                            }
                        }
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField.equals((Object)GroupModel.SearchableFields.NAME)) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NOT_EXISTS: {
                if (modelField.equals((Object)GroupModel.SearchableFields.PARENT_ID)) {
                    return new JpaGroupModelCriteriaBuilder((cb, root) -> cb.isNull((Expression)root.get("parentId")));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

