/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.connection;

import java.sql.Connection;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.storage.jpa.liquibase.connection.MapLiquibaseConnectionProvider;

public class DefaultLiquibaseConnectionProvider
implements MapLiquibaseConnectionProvider {
    private static final Logger logger = Logger.getLogger(DefaultLiquibaseConnectionProvider.class);

    public DefaultLiquibaseConnectionProvider(KeycloakSession session) {
    }

    public void close() {
    }

    @Override
    public Liquibase getLiquibaseForCustomUpdate(Connection connection, String defaultSchema, String changelogLocation, ClassLoader classloader, String changelogTableName) throws LiquibaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        if (defaultSchema != null) {
            database.setDefaultSchemaName(defaultSchema);
        }
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(classloader);
        database.setDatabaseChangeLogTableName(changelogTableName);
        logger.debugf("Using changelog file %s and changelogTableName %s", (Object)changelogLocation, (Object)database.getDatabaseChangeLogTableName());
        return new Liquibase(changelogLocation, (ResourceAccessor)resourceAccessor, database);
    }
}

