/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.extension;

import java.util.List;
import java.util.stream.Collectors;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeStatus;
import liquibase.change.ChangeWithColumns;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.DropIndexChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import org.keycloak.models.map.storage.jpa.liquibase.extension.CreateJsonIndexStatement;
import org.keycloak.models.map.storage.jpa.liquibase.extension.JsonEnabledColumnConfig;

@DatabaseChange(name="createJsonIndex", description="Creates an index for one or more JSON properties", priority=1, appliesTo={"index"})
public class CreateJsonIndexChange
extends AbstractChange
implements ChangeWithColumns<JsonEnabledColumnConfig> {
    private final CreateIndexChange delegate = new CreateIndexChange();

    @DatabaseChangeProperty
    public String getCatalogName() {
        return this.delegate.getCatalogName();
    }

    public void setCatalogName(String catalogName) {
        this.delegate.setCatalogName(catalogName);
    }

    @DatabaseChangeProperty(mustEqualExisting="index.schema")
    public String getSchemaName() {
        return this.delegate.getSchemaName();
    }

    public void setSchemaName(String schemaName) {
        this.delegate.setSchemaName(schemaName);
    }

    @DatabaseChangeProperty(mustEqualExisting="index.table", description="Name of the table to add the index to", exampleValue="person")
    public String getTableName() {
        return this.delegate.getTableName();
    }

    public void setTableName(String tableName) {
        this.delegate.setTableName(tableName);
    }

    @DatabaseChangeProperty(mustEqualExisting="index", description="Name of the index to create")
    public String getIndexName() {
        return this.delegate.getIndexName();
    }

    public void setIndexName(String indexName) {
        this.delegate.setIndexName(indexName);
    }

    @DatabaseChangeProperty(description="Tablepace to create the index in.")
    public String getTablespace() {
        return this.delegate.getTablespace();
    }

    public void setTablespace(String tablespace) {
        this.delegate.setTablespace(tablespace);
    }

    @DatabaseChangeProperty(description="Unique values index", since="1.8")
    public Boolean isUnique() {
        return this.delegate.isUnique();
    }

    public void setUnique(Boolean isUnique) {
        this.delegate.setUnique(isUnique);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getAssociatedWith() {
        return this.delegate.getAssociatedWith();
    }

    public void setAssociatedWith(String associatedWith) {
        this.delegate.setAssociatedWith(associatedWith);
    }

    @DatabaseChangeProperty
    public Boolean getClustered() {
        return this.delegate.getClustered();
    }

    public void setClustered(Boolean clustered) {
        this.delegate.setClustered(clustered);
    }

    public void addColumn(JsonEnabledColumnConfig column) {
        this.delegate.addColumn((AddColumnConfig)column);
    }

    @DatabaseChangeProperty(mustEqualExisting="index.column", description="Column(s) to add to the index", requiredForDatabase={"all"})
    public List<JsonEnabledColumnConfig> getColumns() {
        return this.delegate.getColumns().stream().map(JsonEnabledColumnConfig.class::cast).collect(Collectors.toList());
    }

    public void setColumns(List<JsonEnabledColumnConfig> columns) {
        columns.forEach(arg_0 -> ((CreateIndexChange)this.delegate).addColumn(arg_0));
    }

    public String getConfirmationMessage() {
        return this.delegate.getConfirmationMessage();
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new CreateJsonIndexStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getIndexName(), this.isUnique(), this.getAssociatedWith(), this.getTablespace(), this.getClustered(), this.getColumns().toArray(new JsonEnabledColumnConfig[0]))};
    }

    protected Change[] createInverses() {
        DropIndexChange inverse = new DropIndexChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setIndexName(this.getIndexName());
        return new Change[]{inverse};
    }

    public ChangeStatus checkStatus(Database database) {
        return this.delegate.checkStatus(database);
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    public Object getSerializableFieldValue(String field) {
        return this.delegate.getSerializableFieldValue(field);
    }
}

