/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.liquibase.extension;

import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.DatabaseDataType;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.core.AddColumnStatement;
import liquibase.structure.DatabaseObject;
import org.keycloak.models.map.storage.jpa.liquibase.extension.GeneratedColumnStatement;

public class GeneratedColumnSqlGenerator
extends AddColumnGenerator {
    public int getPriority() {
        return 2;
    }

    public boolean supports(AddColumnStatement statement, Database database) {
        return statement instanceof GeneratedColumnStatement;
    }

    protected Sql[] generateSingleColumn(AddColumnStatement statement, Database database) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(super.generateSingleColumBaseSQL(statement, database));
        sqlBuilder.append(super.generateSingleColumnSQL(statement, database));
        this.handleGeneratedColumn((GeneratedColumnStatement)statement, database, sqlBuilder);
        ArrayList<UnparsedSql> returnSql = new ArrayList<UnparsedSql>();
        returnSql.add(new UnparsedSql(sqlBuilder.toString(), new DatabaseObject[]{super.getAffectedColumn(statement)}));
        super.addUniqueConstraintStatements(statement, database, returnSql);
        super.addForeignKeyStatements(statement, database, returnSql);
        return returnSql.toArray(new Sql[0]);
    }

    protected void handleGeneratedColumn(GeneratedColumnStatement statement, Database database, StringBuilder sqlBuilder) {
        if (database instanceof PostgresDatabase) {
            DatabaseDataType columnType = DataTypeFactory.getInstance().fromDescription(statement.getColumnType(), database).toDatabaseDataType(database);
            sqlBuilder.append(" GENERATED ALWAYS AS ((").append(statement.getJsonColumn()).append("->>'").append(statement.getJsonProperty()).append("')::").append(columnType).append(") stored");
        }
    }
}

