/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.validators;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.logging.Logger;
import org.keycloak.dom.saml.common.CommonConditionsType;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.assertion.ConditionAbstractType;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.OneTimeUseType;
import org.keycloak.dom.saml.v2.assertion.ProxyRestrictionType;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.saml.validators.DestinationValidator;

public class ConditionsValidator {
    private static final Logger LOG = Logger.getLogger(ConditionsValidator.class);
    private final CommonConditionsType conditions;
    private final int clockSkewInMillis;
    private final String assertionId;
    private final XMLGregorianCalendar now = XMLTimeUtil.getIssueInstant();
    private final Set<URI> allowedAudiences;
    private final DestinationValidator destinationValidator;
    private int oneTimeConditionsCount = 0;
    private int proxyRestrictionsCount = 0;

    private ConditionsValidator(String assertionId, CommonConditionsType conditions, int clockSkewInMillis, Set<URI> allowedAudiences, DestinationValidator destinationValidator) {
        this.assertionId = assertionId;
        this.conditions = conditions;
        this.clockSkewInMillis = clockSkewInMillis;
        this.allowedAudiences = allowedAudiences;
        this.destinationValidator = destinationValidator;
    }

    public boolean isValid() {
        if (this.conditions == null) {
            return true;
        }
        Result res = this.validateExpiration();
        if (this.conditions instanceof ConditionsType) {
            res = this.validateConditions((ConditionsType)this.conditions, res);
        } else {
            res = Result.INDETERMINATE;
            LOG.infof("Unknown conditions in assertion %s: %s", (Object)this.assertionId, (Object)(this.conditions == null ? "<null>" : this.conditions.getClass().getSimpleName()));
        }
        LOG.debugf("Assertion %s validity is %s", (Object)this.assertionId, (Object)res.name());
        return Result.VALID == res;
    }

    private Result validateConditions(ConditionsType ct, Result res) {
        Iterator<Object> it;
        Iterator<Object> iterator = it = ct.getConditions() == null ? Collections.emptySet().iterator() : ct.getConditions().iterator();
        while (it.hasNext() && res == Result.VALID) {
            Result r;
            ConditionAbstractType cond = (ConditionAbstractType)it.next();
            if (cond instanceof OneTimeUseType) {
                r = this.validateOneTimeUse((OneTimeUseType)cond);
            } else if (cond instanceof AudienceRestrictionType) {
                r = this.validateAudienceRestriction((AudienceRestrictionType)cond);
            } else if (cond instanceof ProxyRestrictionType) {
                r = this.validateProxyRestriction((ProxyRestrictionType)cond);
            } else {
                r = Result.INDETERMINATE;
                LOG.infof("Unknown condition in assertion %s: %s", (Object)this.assertionId, cond == null ? "<null>" : cond.getClass());
            }
            res = r.joinResult(res);
        }
        return res;
    }

    private Result validateExpiration() {
        XMLGregorianCalendar notBefore = this.conditions.getNotBefore();
        XMLGregorianCalendar notOnOrAfter = this.conditions.getNotOnOrAfter();
        if (notBefore == null && notOnOrAfter == null) {
            return Result.VALID;
        }
        if (notBefore != null && notOnOrAfter != null && notBefore.compare(notOnOrAfter) != -1) {
            return Result.INVALID;
        }
        XMLGregorianCalendar updatedNotBefore = XMLTimeUtil.subtract(notBefore, this.clockSkewInMillis);
        XMLGregorianCalendar updatedOnOrAfter = XMLTimeUtil.add(notOnOrAfter, this.clockSkewInMillis);
        LOG.debugf("Evaluating Conditions of Assertion %s. notBefore=%s, notOnOrAfter=%s, updatedNotBefore: %s, updatedOnOrAfter=%s, now: %s", new Object[]{this.assertionId, notBefore, notOnOrAfter, updatedNotBefore, updatedOnOrAfter, this.now});
        boolean valid = XMLTimeUtil.isValid(this.now, updatedNotBefore, updatedOnOrAfter);
        if (!valid) {
            LOG.infof("Assertion %s expired.", (Object)this.assertionId);
        }
        return valid ? Result.VALID : Result.INVALID;
    }

    private Result validateAudienceRestriction(AudienceRestrictionType cond) {
        for (URI aud : cond.getAudience()) {
            for (URI allowedAudience : this.allowedAudiences) {
                if (!this.destinationValidator.validate(aud, allowedAudience)) continue;
                return Result.VALID;
            }
        }
        LOG.infof("Assertion %s is not addressed to this SP.", (Object)this.assertionId);
        LOG.debugf("Allowed audiences are: %s", this.allowedAudiences);
        return Result.INVALID;
    }

    private Result validateOneTimeUse(OneTimeUseType cond) {
        ++this.oneTimeConditionsCount;
        if (this.oneTimeConditionsCount > 1) {
            LOG.info((Object)"Invalid conditions: Multiple <OneTimeUse/> conditions found.");
            return Result.INVALID;
        }
        return Result.VALID;
    }

    private Result validateProxyRestriction(ProxyRestrictionType cond) {
        ++this.proxyRestrictionsCount;
        if (this.proxyRestrictionsCount > 1) {
            LOG.info((Object)"Invalid conditions: Multiple <ProxyRestriction/> conditions found.");
            return Result.INVALID;
        }
        return Result.VALID;
    }

    public static class Builder {
        private final String assertionId;
        private final CommonConditionsType conditions;
        private final DestinationValidator destinationValidator;
        private int clockSkewInMillis = 0;
        private final Set<URI> allowedAudiences = new HashSet<URI>();

        public Builder(String assertionId, CommonConditionsType conditions, DestinationValidator destinationValidator) {
            this.assertionId = assertionId;
            this.conditions = conditions;
            this.destinationValidator = destinationValidator;
        }

        public Builder clockSkewInMillis(int clockSkewInMillis) {
            this.clockSkewInMillis = clockSkewInMillis;
            return this;
        }

        public Builder addAllowedAudience(URI ... allowedAudiences) {
            this.allowedAudiences.addAll(Arrays.asList(allowedAudiences));
            return this;
        }

        public ConditionsValidator build() {
            return new ConditionsValidator(this.assertionId, this.conditions, this.clockSkewInMillis, this.allowedAudiences, this.destinationValidator);
        }
    }

    public static enum Result {
        VALID{

            @Override
            public Result joinResult(Result otherResult) {
                return otherResult;
            }
        }
        ,
        INDETERMINATE{

            @Override
            public Result joinResult(Result otherResult) {
                return otherResult == INVALID ? INVALID : INDETERMINATE;
            }
        }
        ,
        INVALID{

            @Override
            public Result joinResult(Result otherResult) {
                return INVALID;
            }
        };


        protected abstract Result joinResult(Result var1);
    }
}

