/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.util.JsonSerialization;

public class MapperTypeSerializer {
    private static final TypeReference<List<StringPair>> MAP_TYPE_REPRESENTATION = new TypeReference<List<StringPair>>(){};

    public static Map<String, List<String>> deserialize(String configString) {
        if (configString == null) {
            return Collections.emptyMap();
        }
        try {
            List map = (List)JsonSerialization.readValue((String)configString, MAP_TYPE_REPRESENTATION);
            return map.stream().collect(Collectors.collectingAndThen(Collectors.groupingBy(StringPair::getKey, Collectors.mapping(StringPair::getValue, Collectors.toUnmodifiableList())), Collections::unmodifiableMap));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not deserialize json: " + configString, e);
        }
    }

    public static String serialize(Map<String, List<String>> config) {
        List pairs = config.entrySet().stream().flatMap(entry -> {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            return values.stream().map(value -> new StringPair(key, (String)value));
        }).toList();
        try {
            return JsonSerialization.writeValueAsString(pairs);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not serialize json: " + config, e);
        }
    }

    static class StringPair {
        private String key;
        private String value;

        public StringPair() {
        }

        private StringPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

