/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.StreamSerializer;
import java.util.stream.Stream;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

@Provider
public class ObjectMapperResolver
implements ContextResolver<ObjectMapper> {
    protected ObjectMapper mapper = new ObjectMapper();

    public ObjectMapperResolver() {
        JavaType type = TypeFactory.unknownType();
        JavaType streamType = this.mapper.getTypeFactory().constructParametricType(Stream.class, new JavaType[]{type});
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new StreamSerializer(streamType, type));
        this.mapper.registerModule((Module)module);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        if (Boolean.parseBoolean(System.getProperty("keycloak.jsonPrettyPrint", "false"))) {
            this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }
}

