/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.OID4VCClientRegistrationProvider;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.protocol.oid4vc.model.CredentialOfferURI;
import org.keycloak.protocol.oid4vc.model.CredentialRequest;
import org.keycloak.protocol.oid4vc.model.CredentialResponse;
import org.keycloak.protocol.oid4vc.model.CredentialsOffer;
import org.keycloak.protocol.oid4vc.model.ErrorResponse;
import org.keycloak.protocol.oid4vc.model.ErrorType;
import org.keycloak.protocol.oid4vc.model.Format;
import org.keycloak.protocol.oid4vc.model.OID4VCClient;
import org.keycloak.protocol.oid4vc.model.OfferUriType;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedCode;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedGrant;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.protocol.oidc.grants.PreAuthorizedCodeGrantType;
import org.keycloak.protocol.oidc.utils.OAuth2Code;
import org.keycloak.protocol.oidc.utils.OAuth2CodeParser;
import org.keycloak.provider.Provider;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public class OID4VCIssuerEndpoint {
    private static final Logger LOGGER = Logger.getLogger(OID4VCIssuerEndpoint.class);
    private Cors cors;
    public static final String CREDENTIAL_PATH = "credential";
    public static final String CREDENTIAL_OFFER_PATH = "credential-offer/";
    public static final String RESPONSE_TYPE_IMG_PNG = "image/png";
    public static final String CREDENTIAL_OFFER_URI_CODE_SCOPE = "credential-offer";
    private final KeycloakSession session;
    private final AppAuthManager.BearerTokenAuthenticator bearerTokenAuthenticator;
    private final ObjectMapper objectMapper;
    private final TimeProvider timeProvider;
    private final String issuerDid;
    private final int preAuthorizedCodeLifeSpan;
    private final Map<String, VerifiableCredentialsSigningService> signingServices;
    private final boolean isIgnoreScopeCheck;

    public OID4VCIssuerEndpoint(KeycloakSession session, String issuerDid, Map<String, VerifiableCredentialsSigningService> signingServices, AppAuthManager.BearerTokenAuthenticator authenticator, ObjectMapper objectMapper, TimeProvider timeProvider, int preAuthorizedCodeLifeSpan) {
        this.session = session;
        this.bearerTokenAuthenticator = authenticator;
        this.objectMapper = objectMapper;
        this.timeProvider = timeProvider;
        this.issuerDid = issuerDid;
        this.signingServices = signingServices;
        this.preAuthorizedCodeLifeSpan = preAuthorizedCodeLifeSpan;
        this.isIgnoreScopeCheck = false;
    }

    public OID4VCIssuerEndpoint(KeycloakSession session, String issuerDid, Map<String, VerifiableCredentialsSigningService> signingServices, AppAuthManager.BearerTokenAuthenticator authenticator, ObjectMapper objectMapper, TimeProvider timeProvider, int preAuthorizedCodeLifeSpan, boolean isIgnoreScopeCheck) {
        this.session = session;
        this.bearerTokenAuthenticator = authenticator;
        this.objectMapper = objectMapper;
        this.timeProvider = timeProvider;
        this.issuerDid = issuerDid;
        this.signingServices = signingServices;
        this.preAuthorizedCodeLifeSpan = preAuthorizedCodeLifeSpan;
        this.isIgnoreScopeCheck = isIgnoreScopeCheck;
    }

    @GET
    @Produces(value={"application/json", "image/png"})
    @Path(value="credential-offer-uri")
    public Response getCredentialOfferURI(@QueryParam(value="credential_configuration_id") String vcId, @QueryParam(value="type") @DefaultValue(value="uri") OfferUriType type, @QueryParam(value="width") @DefaultValue(value="200") int width, @QueryParam(value="height") @DefaultValue(value="200") int height) {
        AuthenticatedClientSessionModel clientSession = this.getAuthenticatedClientSession();
        Map<String, SupportedCredentialConfiguration> credentialsMap = OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.session);
        LOGGER.debugf("Get an offer for %s", (Object)vcId);
        if (!credentialsMap.containsKey(vcId)) {
            LOGGER.debugf("No credential with id %s exists.", (Object)vcId);
            LOGGER.debugf("Supported credentials are %s.", credentialsMap);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        SupportedCredentialConfiguration supportedCredentialConfiguration = credentialsMap.get(vcId);
        String format = supportedCredentialConfiguration.getFormat();
        if (this.getClientsOfScope(supportedCredentialConfiguration.getScope(), format).isEmpty()) {
            LOGGER.debugf("No OID4VP-Client supporting type %s registered.", (Object)supportedCredentialConfiguration.getScope());
            throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_TYPE));
        }
        int expiration = this.timeProvider.currentTimeSeconds() + this.preAuthorizedCodeLifeSpan;
        String preAuthorizedCode = this.generateAuthorizationCodeForClientSession(expiration, clientSession);
        CredentialsOffer theOffer = new CredentialsOffer().setCredentialIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext())).setCredentialConfigurationIds(List.of(supportedCredentialConfiguration.getId())).setGrants(new PreAuthorizedGrant().setPreAuthorizedCode(new PreAuthorizedCode().setPreAuthorizedCode(preAuthorizedCode)));
        String sessionCode = this.generateCodeForSession(expiration, clientSession);
        try {
            clientSession.setNote(sessionCode, this.objectMapper.writeValueAsString((Object)theOffer));
        }
        catch (JsonProcessingException e) {
            LOGGER.errorf("Could not convert the offer POJO to JSON: %s", (Object)e.getMessage());
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OfferUriType.URI -> this.getOfferUriAsUri(sessionCode);
            case OfferUriType.QR_CODE -> this.getOfferUriAsQr(sessionCode, width, height);
        };
    }

    private Response getOfferUriAsUri(String sessionCode) {
        CredentialOfferURI credentialOfferURI = new CredentialOfferURI().setIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext()) + "/protocol/oid4vc/credential-offer/").setNonce(sessionCode);
        return Response.ok().type("application/json").entity((Object)credentialOfferURI).build();
    }

    private Response getOfferUriAsQr(String sessionCode, int width, int height) {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        String encodedOfferUri = URLEncoder.encode(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext()) + "/protocol/oid4vc/credential-offer/" + sessionCode, StandardCharsets.UTF_8);
        try {
            BitMatrix bitMatrix = qrCodeWriter.encode("openid-credential-offer://?credential_offer_uri=" + encodedOfferUri, BarcodeFormat.QR_CODE, width, height);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)bos);
            return Response.ok().type(RESPONSE_TYPE_IMG_PNG).entity((Object)bos.toByteArray()).build();
        }
        catch (WriterException | IOException e) {
            LOGGER.warnf("Was not able to create a qr code of dimension %s:%s.", (Object)width, (Object)height, (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Was not able to generate qr.").build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="credential-offer/{sessionCode}")
    public Response getCredentialOffer(@PathParam(value="sessionCode") String sessionCode) {
        if (sessionCode == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        CredentialsOffer credentialsOffer = this.getOfferFromSessionCode(sessionCode);
        LOGGER.debugf("Responding with offer: %s", (Object)credentialsOffer);
        return Response.ok().entity((Object)credentialsOffer).build();
    }

    private void checkScope(CredentialRequest credentialRequestVO) {
        AuthenticatedClientSessionModel clientSession = this.getAuthenticatedClientSession();
        String vcIssuanceFlow = clientSession.getNote("VC-Issuance-Flow");
        if (vcIssuanceFlow == null || !vcIssuanceFlow.equals("urn:ietf:params:oauth:grant-type:pre-authorized_code")) {
            ClientModel client = clientSession.getClient();
            String credentialIdentifier = credentialRequestVO.getCredentialIdentifier();
            String scope = (String)client.getAttributes().get("vc." + credentialIdentifier + ".scope");
            AccessToken accessToken = this.bearerTokenAuthenticator.authenticate().getToken();
            if (((Stream)Arrays.stream(accessToken.getScope().split(" ")).sequential()).noneMatch(i -> i.equals(scope))) {
                LOGGER.debugf("Scope check failure: credentialIdentifier = %s, required scope = %s, scope in access token = %s.", (Object)credentialIdentifier, (Object)scope, (Object)accessToken.getScope());
                throw new CorsErrorResponseException(this.cors, ErrorType.UNSUPPORTED_CREDENTIAL_TYPE.toString(), "Scope check failure", Response.Status.BAD_REQUEST);
            }
            LOGGER.debugf("Scope check success: credentialIdentifier = %s, required scope = %s, scope in access token = %s.", (Object)credentialIdentifier, (Object)scope, (Object)accessToken.getScope());
        } else {
            clientSession.removeNote("VC-Issuance-Flow");
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="credential")
    public Response requestCredential(CredentialRequest credentialRequestVO) {
        LOGGER.debugf("Received credentials request %s.", (Object)credentialRequestVO);
        this.cors = Cors.builder().auth().allowedMethods(new String[]{"POST"}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods"});
        AuthenticationManager.AuthResult authResult = this.getAuthResult();
        if (!this.isIgnoreScopeCheck) {
            this.checkScope(credentialRequestVO);
        }
        String requestedCredentialId = credentialRequestVO.getCredentialIdentifier();
        String requestedFormat = credentialRequestVO.getFormat();
        if (requestedCredentialId == null && requestedFormat == null) {
            LOGGER.debugf("Missing both configuration id and requested format. At least one shall be specified.", new Object[0]);
            throw new BadRequestException(this.getErrorResponse(ErrorType.MISSING_CREDENTIAL_CONFIG_AND_FORMAT));
        }
        Map<String, SupportedCredentialConfiguration> supportedCredentials = OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.session);
        SupportedCredentialConfiguration supportedCredentialConfiguration = null;
        if (requestedCredentialId != null) {
            supportedCredentialConfiguration = supportedCredentials.get(requestedCredentialId);
            if (supportedCredentialConfiguration == null) {
                LOGGER.debugf("Credential with configuration id %s not found.", (Object)requestedCredentialId);
                throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_TYPE));
            }
            if (requestedFormat != null && !requestedFormat.equals(supportedCredentialConfiguration.getFormat())) {
                LOGGER.debugf("Credential with configuration id %s does not support requested format %s, but supports %s.", (Object)requestedCredentialId, (Object)requestedFormat, (Object)supportedCredentialConfiguration.getFormat());
                throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_FORMAT));
            }
        }
        if (supportedCredentialConfiguration == null && requestedFormat != null && (supportedCredentialConfiguration = this.getSupportedCredentialConfiguration(credentialRequestVO, supportedCredentials, requestedFormat)) == null) {
            LOGGER.debugf("Credential with requested format %s, not supported.", (Object)requestedFormat);
            throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_FORMAT));
        }
        CredentialResponse responseVO = new CredentialResponse();
        Object theCredential = this.getCredential(authResult, supportedCredentialConfiguration, credentialRequestVO);
        if (!Format.SUPPORTED_FORMATS.contains(requestedFormat)) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_TYPE));
        }
        responseVO.setCredential(theCredential);
        return Response.ok().entity((Object)responseVO).build();
    }

    private SupportedCredentialConfiguration getSupportedCredentialConfiguration(CredentialRequest credentialRequestVO, Map<String, SupportedCredentialConfiguration> supportedCredentials, String requestedFormat) {
        List configs = supportedCredentials.values().stream().filter(supportedCredential -> Objects.equals(supportedCredential.getFormat(), requestedFormat)).collect(Collectors.toList());
        List matchingConfigs = switch (requestedFormat) {
            case "vc+sd-jwt" -> configs.stream().filter(supportedCredential -> Objects.equals(supportedCredential.getVct(), credentialRequestVO.getVct())).collect(Collectors.toList());
            case "jwt_vc", "ldp_vc" -> configs.stream().filter(supportedCredential -> Objects.equals(supportedCredential.getCredentialDefinition(), credentialRequestVO.getCredentialDefinition())).collect(Collectors.toList());
            default -> throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_FORMAT));
        };
        if (matchingConfigs.isEmpty()) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.MISSING_CREDENTIAL_CONFIG));
        }
        return (SupportedCredentialConfiguration)matchingConfigs.iterator().next();
    }

    private AuthenticatedClientSessionModel getAuthenticatedClientSession() {
        AuthenticationManager.AuthResult authResult = this.getAuthResult();
        UserSessionModel userSessionModel = authResult.getSession();
        AuthenticatedClientSessionModel clientSession = userSessionModel.getAuthenticatedClientSessionByClient(authResult.getClient().getId());
        if (clientSession == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
        }
        return clientSession;
    }

    private AuthenticationManager.AuthResult getAuthResult() {
        return this.getAuthResult((WebApplicationException)new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN)));
    }

    private AuthenticationManager.AuthResult getAuthResult(WebApplicationException errorResponse) {
        AuthenticationManager.AuthResult authResult = this.bearerTokenAuthenticator.authenticate();
        if (authResult == null) {
            throw errorResponse;
        }
        return authResult;
    }

    private Object getCredential(AuthenticationManager.AuthResult authResult, SupportedCredentialConfiguration credentialConfig, CredentialRequest credentialRequestVO) {
        List<OID4VCClient> clients = this.getClientsOfScope(credentialConfig.getScope(), credentialConfig.getFormat());
        List<OID4VCMapper> protocolMappers = this.getProtocolMappers(clients).stream().map(pm -> {
            OID4VCMapper mapperFactory;
            ProtocolMapper protocolMapper;
            Provider patt21883$temp = this.session.getProvider(ProtocolMapper.class, pm.getProtocolMapper());
            if (patt21883$temp instanceof OID4VCMapper && (protocolMapper = (ProtocolMapper)(mapperFactory = (OID4VCMapper)patt21883$temp).create(this.session)) instanceof OID4VCMapper) {
                OID4VCMapper oid4VCMapper = (OID4VCMapper)protocolMapper;
                oid4VCMapper.setMapperModel((ProtocolMapperModel)pm);
                return oid4VCMapper;
            }
            LOGGER.warnf("The protocol mapper %s is not an instance of OID4VCMapper.", (Object)pm.getId());
            return null;
        }).filter(Objects::nonNull).toList();
        VCIssuanceContext vcIssuanceContext = this.getVCToSign(protocolMappers, credentialConfig, authResult, credentialRequestVO);
        String fullyQualifiedConfigKey = VerifiableCredentialsSigningService.locator(credentialConfig.getFormat(), credentialConfig.deriveType(), credentialConfig.deriveConfiId());
        String formatAndTypeKey = VerifiableCredentialsSigningService.locator(credentialConfig.getFormat(), credentialConfig.deriveType(), null);
        String formatOnlyKey = VerifiableCredentialsSigningService.locator(credentialConfig.getFormat(), null, null);
        VerifiableCredentialsSigningService signingService = this.signingServices.getOrDefault(fullyQualifiedConfigKey, this.signingServices.getOrDefault(formatAndTypeKey, this.signingServices.get(formatOnlyKey)));
        return Optional.ofNullable(signingService).map(service -> service.signCredential(vcIssuanceContext)).orElseThrow(() -> new BadRequestException(String.format("No signer found for specific config '%s' or '%s' or format '%s'.", fullyQualifiedConfigKey, formatAndTypeKey, formatOnlyKey)));
    }

    private List<ProtocolMapperModel> getProtocolMappers(List<OID4VCClient> oid4VCClients) {
        return oid4VCClients.stream().map(OID4VCClient::getClientDid).map(this::getClient).flatMap(ProtocolMapperContainerModel::getProtocolMappersStream).toList();
    }

    private String generateCodeForSession(int expiration, AuthenticatedClientSessionModel clientSession) {
        String codeId = SecretGenerator.getInstance().randomString();
        String nonce = SecretGenerator.getInstance().randomString();
        OAuth2Code oAuth2Code = new OAuth2Code(codeId, expiration, nonce, CREDENTIAL_OFFER_URI_CODE_SCOPE, null, null, null, clientSession.getUserSession().getId());
        return OAuth2CodeParser.persistCode(this.session, clientSession, oAuth2Code);
    }

    private CredentialsOffer getOfferFromSessionCode(String sessionCode) {
        EventBuilder eventBuilder = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        OAuth2CodeParser.ParseResult result = OAuth2CodeParser.parseCode(this.session, sessionCode, this.session.getContext().getRealm(), eventBuilder);
        if (result.isExpiredCode() || result.isIllegalCode() || !result.getCodeData().getScope().equals(CREDENTIAL_OFFER_URI_CODE_SCOPE)) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
        }
        try {
            CredentialsOffer credentialsOffer = (CredentialsOffer)this.objectMapper.readValue(result.getClientSession().getNote(sessionCode), CredentialsOffer.class);
            return credentialsOffer;
        }
        catch (JsonProcessingException e) {
            LOGGER.errorf("Could not convert JSON to POJO: %s", (Object)e);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
        }
        finally {
            result.getClientSession().removeNote(sessionCode);
        }
    }

    private String generateAuthorizationCodeForClientSession(int expiration, AuthenticatedClientSessionModel clientSessionModel) {
        return PreAuthorizedCodeGrantType.getPreAuthorizedCode(this.session, clientSessionModel, expiration);
    }

    private Response getErrorResponse(ErrorType errorType) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(errorType);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).type("application/json").build();
    }

    private List<OID4VCClient> getClientsOfScope(String vcScope, String format) {
        LOGGER.debugf("Retrieve all clients of scope %s, supporting format %s", (Object)vcScope, (Object)format);
        if (Optional.ofNullable(vcScope).filter(scope -> !scope.isEmpty()).isEmpty()) {
            throw new BadRequestException("No VerifiableCredential-Scope was provided in the request.");
        }
        return this.getOID4VCClientsFromSession().stream().filter(oid4VCClient -> oid4VCClient.getSupportedVCTypes().stream().anyMatch(supportedCredential -> supportedCredential.getScope().equals(vcScope))).toList();
    }

    private ClientModel getClient(String clientId) {
        return this.session.clients().getClientByClientId(this.session.getContext().getRealm(), clientId);
    }

    private List<OID4VCClient> getOID4VCClientsFromSession() {
        return this.session.clients().getClientsStream(this.session.getContext().getRealm()).filter(clientModel -> clientModel.getProtocol() != null).filter(clientModel -> clientModel.getProtocol().equals("oid4vc")).map(clientModel -> OID4VCClientRegistrationProvider.fromClientAttributes(clientModel.getClientId(), clientModel.getAttributes())).toList();
    }

    private VCIssuanceContext getVCToSign(List<OID4VCMapper> protocolMappers, SupportedCredentialConfiguration credentialConfig, AuthenticationManager.AuthResult authResult, CredentialRequest credentialRequestVO) {
        VerifiableCredential vc = new VerifiableCredential().setIssuer(URI.create(this.issuerDid)).setIssuanceDate(Instant.ofEpochMilli(this.timeProvider.currentTimeMillis())).setType(List.of(credentialConfig.getScope()));
        HashMap<String, Object> subjectClaims = new HashMap<String, Object>();
        protocolMappers.stream().filter(mapper -> mapper.isScopeSupported(credentialConfig.getScope())).forEach(mapper -> mapper.setClaimsForSubject(subjectClaims, authResult.getSession()));
        subjectClaims.forEach((key, value) -> vc.getCredentialSubject().setClaims((String)key, value));
        protocolMappers.stream().filter(mapper -> mapper.isScopeSupported(credentialConfig.getScope())).forEach(mapper -> mapper.setClaimsForCredential(vc, authResult.getSession()));
        LOGGER.debugf("The credential to sign is: %s", (Object)vc);
        return new VCIssuanceContext().setAuthResult(authResult).setVerifiableCredential(vc).setCredentialConfig(credentialConfig).setCredentialRequest(credentialRequestVO);
    }
}

