/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.net.URI;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningServiceException;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.representations.JsonWebToken;

public class JwtSigningService
extends SigningService<String> {
    private static final Logger LOGGER = Logger.getLogger(JwtSigningService.class);
    private static final String ID_TEMPLATE = "urn:uuid:%s";
    private static final String VC_CLAIM_KEY = "vc";
    private static final String ID_CLAIM_KEY = "id";
    private final SignatureSignerContext signatureSignerContext;
    private final TimeProvider timeProvider;
    private final String tokenType;
    protected final String issuerDid;

    public JwtSigningService(KeycloakSession keycloakSession, String keyId, String algorithmType, String tokenType, String issuerDid, TimeProvider timeProvider) {
        super(keycloakSession, keyId, "jwt_vc", algorithmType);
        this.issuerDid = issuerDid;
        this.timeProvider = timeProvider;
        this.tokenType = tokenType;
        KeyWrapper signingKey = this.getKey(keyId, algorithmType);
        if (signingKey == null) {
            throw new SigningServiceException(String.format("No key for id %s and algorithm %s available.", keyId, algorithmType));
        }
        SignatureProvider signatureProvider = (SignatureProvider)keycloakSession.getProvider(SignatureProvider.class, algorithmType);
        this.signatureSignerContext = signatureProvider.signer(signingKey);
        LOGGER.debugf("Successfully initiated the JWT Signing Service with algorithm %s.", (Object)algorithmType);
    }

    @Override
    public String signCredential(VCIssuanceContext vcIssuanceContext) {
        LOGGER.debugf("Sign credentials to jwt-vc format.", new Object[0]);
        VerifiableCredential verifiableCredential = vcIssuanceContext.getVerifiableCredential();
        long iat = Optional.ofNullable(verifiableCredential.getIssuanceDate()).map(Instant::getEpochSecond).orElse(Long.valueOf(this.timeProvider.currentTimeSeconds()));
        JsonWebToken jsonWebToken = new JsonWebToken().issuer(verifiableCredential.getIssuer().toString()).nbf(Long.valueOf(iat)).id(JwtSigningService.createCredentialId(verifiableCredential));
        jsonWebToken.setOtherClaims(VC_CLAIM_KEY, (Object)verifiableCredential);
        Optional.ofNullable(verifiableCredential.getExpirationDate()).ifPresent(d -> jsonWebToken.exp(Long.valueOf(d.getEpochSecond())));
        Optional.ofNullable(verifiableCredential.getCredentialSubject().getClaims().get(ID_CLAIM_KEY)).map(Object::toString).ifPresent(arg_0 -> ((JsonWebToken)jsonWebToken).subject(arg_0));
        return new JWSBuilder().type(this.tokenType).jsonContent((Object)jsonWebToken).sign(this.signatureSignerContext);
    }

    static String createCredentialId(VerifiableCredential verifiableCredential) {
        return Optional.ofNullable(verifiableCredential.getId()).orElse(URI.create(String.format(ID_TEMPLATE, UUID.randomUUID()))).toString();
    }
}

