/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.Token;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.util.JsonSerialization;

public class AccessTokenIntrospectionProvider
implements TokenIntrospectionProvider {
    private final KeycloakSession session;
    private final TokenManager tokenManager;
    private final RealmModel realm;
    private static final Logger logger = Logger.getLogger(AccessTokenIntrospectionProvider.class);

    public AccessTokenIntrospectionProvider(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.tokenManager = new TokenManager();
    }

    public Response introspect(String token, EventBuilder eventBuilder) {
        AccessToken accessToken = null;
        try {
            boolean isJwtRequest;
            ObjectNode tokenMetadata;
            accessToken = this.verifyAccessToken(token, eventBuilder, false);
            UserSessionModel userSession = this.tokenManager.getValidUserSessionIfTokenIsValid(this.session, this.realm, accessToken, eventBuilder);
            ClientModel client = this.session.getContext().getClient();
            if (userSession != null) {
                String actor;
                accessToken = this.transformAccessToken(accessToken, userSession);
                tokenMetadata = JsonSerialization.createObjectNode((Object)accessToken);
                tokenMetadata.put("client_id", accessToken.getIssuedFor());
                String scope = accessToken.getScope();
                if (scope != null && scope.trim().isEmpty()) {
                    tokenMetadata.remove("scope");
                }
                if (!tokenMetadata.has("username")) {
                    if (accessToken.getPreferredUsername() != null) {
                        tokenMetadata.put("username", accessToken.getPreferredUsername());
                    } else {
                        UserModel userModel = userSession.getUser();
                        if (userModel != null) {
                            tokenMetadata.put("username", userModel.getUsername());
                        }
                    }
                }
                if ((actor = userSession.getNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString())) != null) {
                    tokenMetadata.putObject("act").put("sub", actor);
                }
                tokenMetadata.put("token_type", accessToken.getType());
            } else {
                tokenMetadata = JsonSerialization.createObjectNode();
                logger.debug((Object)"Keycloak token introspection return false");
                eventBuilder.error("token_introspection_failed");
            }
            tokenMetadata.put("active", userSession != null);
            if (accessToken != null && (isJwtRequest = "application/jwt".equals(this.session.getContext().getRequestHeaders().getHeaderString("Accept"))) && Boolean.parseBoolean(client.getAttribute("client.introspection.response.allow.jwt.claim.enabled"))) {
                tokenMetadata.put("jwt", this.session.tokens().encode((Token)accessToken));
            }
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            String clientId = accessToken != null ? accessToken.getIssuedFor() : "unknown";
            logger.debugf((Throwable)e, "Exception during Keycloak introspection for %s client in realm %s", (Object)clientId, (Object)this.realm.getName());
            eventBuilder.detail("reason", e.getMessage());
            eventBuilder.error("token_introspection_failed");
            throw new RuntimeException("Error creating token introspection response.", e);
        }
    }

    public AccessToken transformAccessToken(AccessToken token, UserSessionModel userSession) {
        ClientModel client = this.realm.getClientByClientId(token.getIssuedFor());
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        if (clientSession == null) {
            return token;
        }
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, token.getScope(), this.session);
        AccessToken smallToken = this.getAccessTokenFromStoredData(token);
        return this.tokenManager.transformIntrospectionAccessToken(this.session, smallToken, userSession, clientSessionCtx);
    }

    private AccessToken getAccessTokenFromStoredData(AccessToken token) {
        AccessToken newToken = new AccessToken();
        newToken.id(token.getId());
        newToken.type(token.getType());
        newToken.subject(token.getSubject());
        newToken.iat(token.getIat());
        newToken.exp(token.getExp());
        newToken.issuedFor(token.getIssuedFor());
        newToken.issuer(token.getIssuer());
        newToken.setNonce(token.getNonce());
        newToken.setScope(token.getScope());
        newToken.setSessionId(token.getSessionId());
        newToken.audience(token.getAudience());
        newToken.setConfirmation(token.getConfirmation());
        return newToken;
    }

    protected AccessToken verifyAccessToken(String token, EventBuilder eventBuilder, boolean validateSession) {
        try {
            TokenVerifier verifier = TokenVerifier.create((String)token, AccessToken.class).realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
            SignatureVerifierContext verifierContext = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId());
            verifier.verifierContext(verifierContext);
            AccessToken accessToken = (AccessToken)verifier.verify().getToken();
            if (validateSession) {
                return this.tokenManager.checkTokenValidForIntrospection(this.session, this.realm, (AccessToken)verifier.verify().getToken(), eventBuilder);
            }
            return accessToken;
        }
        catch (VerificationException e) {
            logger.debugf("Introspection access token : JWT check failed: %s", (Object)e.getMessage());
            eventBuilder.detail("reason", "Access token JWT check failed");
            return null;
        }
    }

    public void close() {
    }
}

