/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.par.endpoints.request;

import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;
import org.keycloak.protocol.oidc.par.endpoints.ParEndpoint;
import org.keycloak.protocol.oidc.par.endpoints.request.ParEndpointRequestObjectParser;

public class AuthzEndpointParParser
extends AuthzEndpointRequestParser {
    private static final Logger logger = Logger.getLogger(AuthzEndpointParParser.class);
    private final KeycloakSession session;
    private final ClientModel client;
    private Map<String, String> requestParams;
    private String invalidRequestMessage = null;

    public AuthzEndpointParParser(KeycloakSession session, ClientModel client, String requestUri) {
        String key;
        this.session = session;
        this.client = client;
        SingleUseObjectProvider singleUseStore = session.singleUseObjects();
        try {
            key = requestUri.substring(ParEndpoint.REQUEST_URI_PREFIX_LENGTH);
        }
        catch (RuntimeException re) {
            logger.warnf((Throwable)re, "Unable to parse request_uri: %s", (Object)requestUri);
            throw new RuntimeException("Unable to parse request_uri");
        }
        Map retrievedRequest = singleUseStore.remove(key);
        if (retrievedRequest == null) {
            throw new RuntimeException("PAR not found. not issued or used multiple times.");
        }
        RealmModel realm = session.getContext().getRealm();
        int expiresIn = realm.getParPolicy().getRequestUriLifespan();
        long created = Long.parseLong((String)retrievedRequest.get("par.created.time"));
        if (System.currentTimeMillis() - created >= (long)(expiresIn * 1000)) {
            throw new RuntimeException("PAR expired.");
        }
        this.requestParams = retrievedRequest;
    }

    @Override
    public void parseRequest(AuthorizationEndpointRequest request) {
        String requestParam = this.requestParams.get("request");
        if (requestParam != null) {
            new ParEndpointRequestObjectParser(this.session, requestParam, this.client).parseRequest(request);
        } else {
            super.parseRequest(request);
        }
    }

    @Override
    protected String getParameter(String paramName) {
        return this.requestParams.get(paramName);
    }

    @Override
    protected Integer getIntParameter(String paramName) {
        String paramVal = this.requestParams.get(paramName);
        return paramVal == null ? null : Integer.valueOf(paramVal);
    }

    public String getInvalidRequestMessage() {
        return this.invalidRequestMessage;
    }

    @Override
    protected Set<String> keySet() {
        return this.requestParams.keySet();
    }
}

