/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.ForbiddenException;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class DeleteAccount
implements RequiredActionProvider,
RequiredActionFactory {
    public static final String PROVIDER_ID = "delete_account";
    private static final String TRIGGERED_FROM_AIA = "triggered_from_aia";
    private static final Logger logger = Logger.getLogger(DeleteAccount.class);

    public String getDisplayText() {
        return "Delete Account";
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        if (!this.clientHasDeleteAccountRole(context)) {
            context.challenge(context.form().setError("deletingAccountForbidden", new Object[0]).createForm("error.ftl"));
            return;
        }
        context.challenge(context.form().setAttribute(TRIGGERED_FROM_AIA, (Object)this.isCurrentActionTriggeredFromAIA(context)).createForm("delete-account-confirm.ftl"));
    }

    public void processAction(RequiredActionContext context) {
        KeycloakSession session = context.getSession();
        EventBuilder eventBuilder = context.getEvent();
        KeycloakContext keycloakContext = session.getContext();
        RealmModel realm = keycloakContext.getRealm();
        UserModel user = keycloakContext.getAuthenticationSession().getAuthenticatedUser();
        try {
            if (!this.clientHasDeleteAccountRole(context)) {
                throw new ForbiddenException();
            }
            boolean removed = new UserManager(session).removeUser(realm, user);
            if (removed) {
                eventBuilder.event(EventType.DELETE_ACCOUNT).client(keycloakContext.getClient()).user(user).detail("username", user.getUsername()).success();
                this.removeAuthenticationSession(context, session);
                context.challenge(context.form().setAttribute("messageHeader", (Object)"").setInfo("userDeletedSuccessfully", new Object[0]).createForm("info.ftl"));
            } else {
                eventBuilder.event(EventType.DELETE_ACCOUNT).client(keycloakContext.getClient()).user(user).detail("username", user.getUsername()).error("User could not be deleted");
                this.cleanSession(context, RequiredActionContext.KcActionStatus.ERROR);
                context.failure();
            }
        }
        catch (ForbiddenException forbidden) {
            logger.error((Object)"account client does not have the required roles for user deletion");
            eventBuilder.event(EventType.DELETE_ACCOUNT_ERROR).client(keycloakContext.getClient()).user(keycloakContext.getAuthenticationSession().getAuthenticatedUser()).detail("reason", "does not have the required roles for user deletion").error("user_delete_error");
            context.challenge(context.form().setAttribute(TRIGGERED_FROM_AIA, (Object)this.isCurrentActionTriggeredFromAIA(context)).setError("deletingAccountForbidden", new Object[0]).createForm("delete-account-confirm.ftl"));
        }
        catch (Exception exception) {
            logger.error((Object)"unexpected error happened during account deletion", (Throwable)exception);
            eventBuilder.event(EventType.DELETE_ACCOUNT_ERROR).client(keycloakContext.getClient()).user(keycloakContext.getAuthenticationSession().getAuthenticatedUser()).detail("reason", exception.getMessage()).error("user_delete_error");
            context.challenge(context.form().setError("errorDeletingAccount", new Object[0]).createForm("delete-account-confirm.ftl"));
        }
    }

    private void cleanSession(RequiredActionContext context, RequiredActionContext.KcActionStatus status) {
        context.getAuthenticationSession().removeRequiredAction(PROVIDER_ID);
        context.getAuthenticationSession().removeAuthNote("current.authentication.execution");
        AuthenticationManager.setKcActionStatus(PROVIDER_ID, status, context.getAuthenticationSession());
    }

    private boolean clientHasDeleteAccountRole(RequiredActionContext context) {
        RoleModel deleteAccountRole = context.getRealm().getClientByClientId("account").getRole("delete-account");
        return deleteAccountRole != null && context.getUser().hasRole(deleteAccountRole);
    }

    private boolean isCurrentActionTriggeredFromAIA(RequiredActionContext context) {
        return Objects.equals(context.getAuthenticationSession().getClientNote("kc_action"), PROVIDER_ID);
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public boolean isOneTimeAction() {
        return true;
    }

    public int getMaxAuthAge() {
        return 0;
    }

    private void removeAuthenticationSession(RequiredActionContext context, KeycloakSession session) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        new AuthenticationSessionManager(session).removeAuthenticationSession(authSession.getRealm(), authSession, true);
    }
}

