/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.keycloak.adapters.tomcat.SimpleGroup;
import org.keycloak.adapters.tomcat.SimplePrincipal;

public abstract class GenericPrincipalFactory {
    public GenericPrincipal createPrincipal(Realm realm, Principal identity, Set<String> roleSet) {
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(identity);
        SimpleGroup[] roleSets = this.getRoleSets(roleSet);
        for (int g = 0; g < roleSets.length; ++g) {
            SimpleGroup group = roleSets[g];
            String name = group.getName();
            SimpleGroup subjectGroup = this.createGroup(name, principals);
            Enumeration<? extends Principal> members = group.members();
            while (members.hasMoreElements()) {
                Principal role = members.nextElement();
                subjectGroup.addMember(role);
            }
        }
        Principal userPrincipal = this.getPrincipal(subject);
        ArrayList<String> rolesAsStringList = new ArrayList<String>();
        rolesAsStringList.addAll(roleSet);
        GenericPrincipal principal = this.createPrincipal(userPrincipal, rolesAsStringList);
        return principal;
    }

    protected abstract GenericPrincipal createPrincipal(Principal var1, List<String> var2);

    protected Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                if (p instanceof SimpleGroup || principal != null) continue;
                principal = p;
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    protected SimpleGroup createGroup(String name, Set<Principal> principals) {
        SimpleGroup roles = null;
        for (Principal next : principals) {
            SimpleGroup grp;
            if (!(next instanceof SimpleGroup) || !(grp = (SimpleGroup)next).getName().equals(name)) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            roles = new SimpleGroup(name);
            principals.add(roles);
        }
        return roles;
    }

    protected SimpleGroup[] getRoleSets(Collection<String> roleSet) {
        SimpleGroup roles = new SimpleGroup("Roles");
        SimpleGroup[] roleSets = new SimpleGroup[]{roles};
        for (String role : roleSet) {
            roles.addMember(new SimplePrincipal(role));
        }
        return roleSets;
    }
}

