/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionManager;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.adapters.undertow.OIDCUndertowHttpFacade;
import org.keycloak.adapters.undertow.SessionManagementBridge;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class UndertowPreAuthActionsHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(UndertowPreAuthActionsHandler.class);
    protected HttpHandler next;
    protected SessionManager sessionManager;
    protected UndertowUserSessionManagement userSessionManagement;
    protected AdapterDeploymentContext deploymentContext;

    public UndertowPreAuthActionsHandler(AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement userSessionManagement, SessionManager sessionManager, HttpHandler next) {
        this.next = next;
        this.deploymentContext = deploymentContext;
        this.sessionManager = sessionManager;
        this.userSessionManagement = userSessionManagement;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SessionManagementBridge bridge = new SessionManagementBridge(this.userSessionManagement, this.sessionManager);
        UndertowHttpFacade facade = this.createFacade(exchange);
        PreAuthActionsHandler handler = new PreAuthActionsHandler((UserSessionManagement)bridge, this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            return;
        }
        this.next.handleRequest(exchange);
    }

    public UndertowHttpFacade createFacade(HttpServerExchange exchange) {
        return new OIDCUndertowHttpFacade(exchange);
    }
}

