/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import org.kie.api.internal.utils.KieServiceLoader;

public interface KieService
extends Comparable<KieService> {
    public static final String UNDEFINED = "undefined";

    default public int servicePriority() {
        return 0;
    }

    default public String serviceTag() {
        return UNDEFINED;
    }

    @Override
    default public int compareTo(KieService other) {
        if (this.servicePriority() == other.servicePriority()) {
            throw new IllegalStateException("Found 2 services with same priority (" + this.servicePriority() + "): " + this.getClass().getCanonicalName() + " and " + other.getClass().getCanonicalName());
        }
        return this.servicePriority() - other.servicePriority();
    }

    public static <T extends KieService> T load(Class<T> serviceClass) {
        return KieServiceLoader.INSTANCE.lookup(serviceClass);
    }

    public static <T extends KieService> T loadWithTag(Class<T> serviceClass, String tag) {
        return KieServiceLoader.INSTANCE.lookup(serviceClass, tag);
    }
}

