/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.spring.AbstractJaxrsClassesScanServer;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerContainerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.springboot.SpringBootKieServerImpl;
import org.kie.server.springboot.autoconfiguration.KieServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@EnableConfigurationProperties(value={KieServerProperties.class})
public class KieServerAutoConfiguration
extends AbstractJaxrsClassesScanServer {
    @Value(value="${cxf.path:/}")
    private String cxfPath;
    private static final Logger logger = LoggerFactory.getLogger(KieServerAutoConfiguration.class);
    private KieServerProperties properties;
    private IdentityProvider identityProvider;
    private List<Object> endpoints;
    private boolean jaxrsComponentScanEnabled;
    private SpringBootKieServerImpl kieServer;

    public KieServerAutoConfiguration(KieServerProperties properties, Optional<IdentityProvider> identityProvider, @Value(value="${cxf.jaxrs.classes-scan:false}") boolean jaxrsComponentScanEnabled) {
        this.properties = properties;
        this.jaxrsComponentScanEnabled = jaxrsComponentScanEnabled;
        if (identityProvider.isPresent()) {
            this.identityProvider = identityProvider.get();
        }
        if (!jaxrsComponentScanEnabled) {
            System.setProperty("cxf.jaxrs.classes-scan-packages", "");
        }
    }

    @Bean
    @ConditionalOnMissingBean(name={"kieServerExtension"})
    public KieServerExtension kieServerExtension() {
        return new KieServerContainerExtension();
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean(name={"kieServer"})
    public KieServer kieServer(List<KieServerExtension> extensions) {
        System.setProperty("org.kie.server.controller", this.properties.getControllers());
        System.setProperty("org.kie.server.location", this.properties.getLocation());
        if (KieServerEnvironment.getServerId() == null) {
            String serverName = this.properties.getServerName();
            String serverId = this.properties.getServerId();
            KieServerEnvironment.setServerId((String)serverId.toString());
            KieServerEnvironment.setServerName((String)serverName);
        }
        logger.info("KieServer (id {} (name {})) started initialization process", (Object)KieServerEnvironment.getServerId(), (Object)KieServerEnvironment.getServerName());
        this.kieServer = new SpringBootKieServerImpl(extensions, this.identityProvider);
        this.kieServer.init();
        KieServerRestImpl kieServerResource = new KieServerRestImpl((KieServerImpl)this.kieServer);
        this.endpoints = new ArrayList<Object>();
        this.endpoints.add(kieServerResource);
        List activeExtensions = this.kieServer.getServerExtensions();
        for (KieServerExtension extension : activeExtensions) {
            LinkedHashSet resources = new LinkedHashSet(extension.getAppComponents(SupportedTransports.REST));
            this.endpoints.addAll(resources);
        }
        logger.info("KieServer (id {}) started successfully", (Object)KieServerEnvironment.getServerId());
        return this.kieServer;
    }

    @Bean
    @ConditionalOnBean(name={"kieServer"})
    public KieServerRegistry kieServerRegistry(KieServer server) {
        return this.kieServer.getServerRegistry();
    }

    protected void setJaxrsResources(JAXRSServerFactoryBean factory) {
        factory.setServiceBeans(this.endpoints);
        if (this.jaxrsComponentScanEnabled) {
            super.setJaxrsResources(factory);
        }
    }

    @Bean
    public Server jaxRsServer(KieServer server) {
        return super.createJaxRsServer();
    }

    public List<Feature> getFeatures() {
        ArrayList<Feature> features = new ArrayList<Feature>(super.getFeatures());
        if (this.properties.getSwagger().isEnabled()) {
            try {
                Feature feature = (Feature)Class.forName("org.apache.cxf.jaxrs.swagger.Swagger2Feature").newInstance();
                Method method = ReflectionUtils.findMethod(feature.getClass(), (String)"setRunAsFilter", (Class[])new Class[]{Boolean.TYPE});
                method.invoke((Object)feature, true);
                Method setBasePathMethod = ReflectionUtils.findMethod(feature.getClass(), (String)"setBasePath", (Class[])new Class[]{String.class});
                setBasePathMethod.invoke((Object)feature, this.cxfPath);
                features.add(feature);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                logger.error("Swagger feature was enabled but cannot be created", (Throwable)e);
            }
        }
        return features;
    }
}

