/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.command;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.instance.ProcessInstance;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;

@XmlRootElement(name="suspend-process-instance-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SuspendProcessInstanceCommand
implements ExecutableCommand<Object>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 5824052805419980114L;
    @XmlAttribute
    @XmlSchemaType(name="string")
    private String processInstanceId;

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Object execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        if (this.processInstanceId == null) {
            return null;
        }
        org.kie.api.runtime.process.ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + this.processInstanceId);
        }
        if (processInstance.getState() != 1) {
            throw new IllegalArgumentException("Process instance with id " + this.processInstanceId + " in state " + processInstance.getState());
        }
        ((ProcessInstance)processInstance).setState(4);
        return null;
    }

    public String toString() {
        return "session.abortProcessInstance(" + this.processInstanceId + ");";
    }
}

