/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Date;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.services.time.TimerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(TimerNodeInstance.class);
    private String timerId;

    public TimerNode getTimerNode() {
        return (TimerNode)this.getNode();
    }

    public String getTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(String timerId) {
        this.timerId = timerId;
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A TimerNode only accepts default incoming connections!");
        }
        this.triggerTime = new Date();
        ExpirationTime expirationTime = this.createTimerInstance(this.getTimerNode().getTimer());
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
        JobsService jobService = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService();
        this.timerId = jobService.scheduleProcessInstanceJob(ProcessInstanceJobDescription.of((long)this.getTimerNode().getTimer().getId(), (ExpirationTime)expirationTime, (String)this.getProcessInstance().getId(), (String)this.getProcessInstance().getRootProcessInstanceId(), (String)this.getProcessInstance().getProcessId(), (String)this.getProcessInstance().getRootProcessId()));
    }

    @Override
    public void signalEvent(String type, Object event) {
        TimerInstance timer;
        if ("timerTriggered".equals(type) && (timer = (TimerInstance)event).getId().equals(this.timerId)) {
            this.triggerCompleted(timer.getRepeatLimit() <= 0);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"timerTriggered"};
    }

    @Override
    public void triggerCompleted(boolean remove) {
        this.triggerCompleted("DROOLS_DEFAULT", remove);
    }

    @Override
    public void cancel() {
        ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService().cancelJob(this.timerId);
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("timerTriggered", this, false);
    }
}

