/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.commands.optaplanner;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.KieServerCommand;
import org.optaplanner.core.impl.solver.ProblemFactChange;

@XmlRootElement(name="add-problem-fact-changes")
@XStreamAlias(value="add-problem-fact-changes")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AddProblemFactChangesCommand
implements KieServerCommand {
    private static final long serialVersionUID = -1803374525440238478L;
    @XmlAttribute(name="container-id")
    @XStreamAlias(value="container-id")
    private String containerId;
    @XmlAttribute(name="solver-id")
    @XStreamAlias(value="solver-id")
    private String solverId;
    @XmlElement
    @XStreamAlias(value="problem-fact-changes")
    private List<Object> problemFactChanges;

    public AddProblemFactChangesCommand() {
    }

    public AddProblemFactChangesCommand(String containerId, String solverId, List<? extends ProblemFactChange> problemFactChanges) {
        this.containerId = containerId;
        this.solverId = solverId;
        this.problemFactChanges = new ArrayList<ProblemFactChange>(problemFactChanges);
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getSolverId() {
        return this.solverId;
    }

    public void setSolverId(String solverId) {
        this.solverId = solverId;
    }

    public List<ProblemFactChange> getProblemFactChanges() {
        if (this.problemFactChanges == null) {
            return null;
        }
        return this.problemFactChanges.stream().map(p -> (ProblemFactChange)p).collect(Collectors.toList());
    }

    public void setProblemFactChanges(List<? extends ProblemFactChange> problemFactChanges) {
        this.problemFactChanges = new ArrayList<ProblemFactChange>(problemFactChanges);
    }

    public String toString() {
        return "AddProblemFactChangesCommand{containerId='" + this.containerId + '\'' + ", solverId='" + this.solverId + '\'' + ", problemFactChanges='" + this.problemFactChanges + '\'' + '}';
    }
}

