/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.api.model.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerConfig;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="server-template-details")
public class ServerTemplate
extends ServerTemplateKey {
    @XmlElement(name="container-specs")
    private Collection<ContainerSpec> containersSpec = new ArrayList<ContainerSpec>();
    @XmlElement(name="server-config")
    private Map<Capability, ServerConfig> configs = new HashMap<Capability, ServerConfig>();
    @XmlElement(name="server-instances")
    private Collection<ServerInstanceKey> serverInstances = new ArrayList<ServerInstanceKey>();
    @XmlElement(name="capabilities")
    private List<String> capabilities = new ArrayList<String>();

    public ServerTemplate() {
    }

    public ServerTemplate(String id, String name) {
        super(id, name);
    }

    public ServerTemplate(String id, String name, Collection<String> capabilities, Map<Capability, ServerConfig> configs, Collection<ContainerSpec> containersSpec) {
        super(id, name);
        this.capabilities.addAll(capabilities);
        this.configs.putAll(configs);
        this.containersSpec.addAll(containersSpec);
    }

    public ServerTemplate(String id, String name, Collection<String> capabilities, Map<Capability, ServerConfig> configs, Collection<ContainerSpec> containersSpec, Collection<ServerInstanceKey> serverIntanceKeys) {
        this(id, name, capabilities, configs, containersSpec);
        this.serverInstances.addAll(serverIntanceKeys);
    }

    public Map<Capability, ServerConfig> getConfigs() {
        if (this.configs == null) {
            this.configs = new HashMap<Capability, ServerConfig>();
        }
        return this.configs;
    }

    public Collection<ContainerSpec> getContainersSpec() {
        if (this.containersSpec == null) {
            this.containersSpec = new ArrayList<ContainerSpec>();
        }
        return new ArrayList<ContainerSpec>(this.containersSpec);
    }

    public Collection<ServerInstanceKey> getServerInstanceKeys() {
        if (this.serverInstances == null) {
            this.serverInstances = new ArrayList<ServerInstanceKey>();
        }
        return this.serverInstances;
    }

    public boolean hasContainerSpec(String containerSpecId) {
        for (ContainerSpec spec : this.getContainersSpec()) {
            if (!containerSpecId.equals(spec.getId())) continue;
            return true;
        }
        return false;
    }

    public ContainerSpec getContainerSpec(String containerSpecId) {
        for (ContainerSpec spec : this.getContainersSpec()) {
            if (!containerSpecId.equals(spec.getId())) continue;
            return spec;
        }
        return null;
    }

    public void addContainerSpec(ContainerSpec containerSpec) {
        if (this.containersSpec == null) {
            this.containersSpec = new ArrayList<ContainerSpec>();
        }
        this.containersSpec.add(containerSpec);
    }

    public void deleteContainerSpec(String containerSpecId) {
        if (this.containersSpec == null) {
            return;
        }
        Iterator<ContainerSpec> iterator = this.containersSpec.iterator();
        while (iterator.hasNext()) {
            ContainerSpec spec = iterator.next();
            if (!containerSpecId.equals(spec.getId())) continue;
            iterator.remove();
        }
    }

    public boolean hasServerInstance(String serverInstanceUrl) {
        for (ServerInstanceKey spec : this.getServerInstanceKeys()) {
            if (!serverInstanceUrl.equals(spec.getUrl())) continue;
            return true;
        }
        return false;
    }

    public void addServerInstance(ServerInstanceKey serverInstance) {
        if (this.serverInstances == null) {
            this.serverInstances = new ArrayList<ServerInstanceKey>();
        }
        if (!this.serverInstances.contains(serverInstance)) {
            this.serverInstances.add(serverInstance);
        }
    }

    public void deleteServerInstance(String serverInstanceId) {
        if (this.serverInstances == null) {
            return;
        }
        Iterator<ServerInstanceKey> iterator = this.serverInstances.iterator();
        while (iterator.hasNext()) {
            ServerInstanceKey serverInstanceKey = iterator.next();
            if (!serverInstanceId.equals(serverInstanceKey.getServerInstanceId())) continue;
            iterator.remove();
        }
    }

    public void setContainersSpec(Collection<ContainerSpec> containersSpec) {
        this.containersSpec = containersSpec;
    }

    public void setConfigs(Map<Capability, ServerConfig> configs) {
        this.configs = configs;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
    }

    public boolean hasMatchingId(ServerTemplateKey serverTemplateKey) {
        return this.getId().equals(serverTemplateKey.getId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerTemplate)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerTemplate that = (ServerTemplate)o;
        return !(this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.capabilities != null ? this.capabilities.hashCode() : 0);
        return result;
    }
}

