/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.spi.AbstractDatasetReader;
import org.kitesdk.data.spi.DescriptorUtil;
import org.kitesdk.data.spi.EntityAccessor;
import org.kitesdk.data.spi.ReaderWriterState;
import org.kitesdk.data.spi.filesystem.CSVProperties;
import org.kitesdk.data.spi.filesystem.CSVRecordBuilder;
import org.kitesdk.data.spi.filesystem.CSVUtil;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileReader<E>
extends AbstractDatasetReader<E> {
    private static final Logger LOG = LoggerFactory.getLogger(CSVFileReader.class);
    private final CSVProperties props;
    private final FileSystem fs;
    private final Path path;
    private final Schema schema;
    private final boolean reuseRecords;
    private final Class<E> recordClass;
    private CSVReader reader = null;
    private CSVRecordBuilder<E> builder;
    private long size = 0L;
    private InputStream incoming = null;
    private ReaderWriterState state = ReaderWriterState.NEW;
    private boolean hasNext = false;
    private String[] next = null;
    private E record = null;

    public CSVFileReader(FileSystem fileSystem, Path path, DatasetDescriptor descriptor, EntityAccessor<E> accessor) {
        this.fs = fileSystem;
        this.path = path;
        this.schema = accessor.getEntitySchema();
        this.recordClass = accessor.getType();
        this.state = ReaderWriterState.NEW;
        this.props = CSVProperties.fromDescriptor(descriptor);
        this.reuseRecords = DescriptorUtil.isEnabled("kite.reader.reuse-records", descriptor);
        Preconditions.checkArgument(Schema.Type.RECORD.equals((Object)this.schema.getType()), "Schemas for CSV files must be records of primitive types");
    }

    public CSVFileReader(InputStream incoming, CSVProperties props, Schema schema, Class<E> type) {
        this.fs = null;
        this.path = null;
        this.incoming = incoming;
        this.schema = schema;
        this.recordClass = type;
        this.state = ReaderWriterState.NEW;
        this.props = props;
        this.reuseRecords = false;
        Preconditions.checkArgument(Schema.Type.RECORD.equals((Object)schema.getType()), "Schemas for CSV files must be records of primitive types");
    }

    @Override
    public void initialize() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.NEW), "A reader may not be opened more than once - current state:%s", new Object[]{this.state});
        if (this.incoming == null) {
            Preconditions.checkNotNull(this.fs, "FileSystem cannot be null");
            Preconditions.checkNotNull(this.path, "Path cannot be null");
            try {
                this.incoming = this.fs.open(this.path);
                this.size = this.fs.getFileStatus(this.path).getLen();
            }
            catch (IOException ex) {
                throw new DatasetIOException("Cannot open path: " + this.path, ex);
            }
        }
        this.reader = CSVUtil.newReader(this.incoming, this.props);
        ArrayList<String> header = null;
        if (this.props.useHeader) {
            this.hasNext = this.advance();
            header = Lists.newArrayList(this.next);
        } else if (this.props.header != null) {
            try {
                header = Lists.newArrayList(CSVUtil.newParser(this.props).parseLine(this.props.header));
            }
            catch (IOException e) {
                throw new DatasetIOException("Failed to parse header from properties: " + this.props.header, e);
            }
        }
        this.builder = new CSVRecordBuilder<E>(this.schema, this.recordClass, header);
        this.hasNext = this.advance();
        this.state = ReaderWriterState.OPEN;
    }

    @Override
    public boolean hasNext() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to read from a file in state:%s", new Object[]{this.state});
        return this.hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        Preconditions.checkState(this.state.equals((Object)ReaderWriterState.OPEN), "Attempt to read from a file in state:%s", new Object[]{this.state});
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        try {
            if (this.reuseRecords) {
                E e = this.record = this.builder.makeRecord(this.next, this.record);
                return e;
            }
            E e = this.builder.makeRecord(this.next, null);
            return e;
        }
        finally {
            this.hasNext = this.advance();
        }
    }

    private boolean advance() {
        try {
            this.next = this.reader.readNext();
        }
        catch (IOException ex) {
            throw new DatasetIOException("Could not read record", ex);
        }
        return this.next != null;
    }

    @Override
    public void close() {
        if (!this.state.equals((Object)ReaderWriterState.OPEN)) {
            return;
        }
        LOG.debug("Closing reader on path:{}", (Object)this.path);
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new DatasetIOException("Unable to close reader path:" + this.path, e);
        }
        this.state = ReaderWriterState.CLOSED;
    }

    @Override
    public boolean isOpen() {
        return this.state == ReaderWriterState.OPEN;
    }

    public RecordReader<E, Void> asRecordReader() {
        Preconditions.checkArgument(this.incoming instanceof FSDataInputStream, "Cannot use {} in a record reader", this.incoming.getClass());
        return new CSVRecordReader();
    }

    public class CSVRecordReader
    extends RecordReader<E, Void> {
        private E current;

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (CSVFileReader.this.hasNext()) {
                this.current = CSVFileReader.this.next();
                return true;
            }
            return false;
        }

        public E getCurrentKey() throws IOException, InterruptedException {
            return this.current;
        }

        public Void getCurrentValue() throws IOException, InterruptedException {
            return null;
        }

        public float getProgress() throws IOException, InterruptedException {
            if (CSVFileReader.this.size == 0L) {
                return 0.0f;
            }
            return (float)((FSDataInputStream)CSVFileReader.this.incoming).getPos() / (float)CSVFileReader.this.size;
        }

        public void close() throws IOException {
            CSVFileReader.this.close();
        }
    }
}

