/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import au.com.bytecode.opencsv.CSVParser;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.filesystem.CSVProperties;
import org.kitesdk.data.spi.filesystem.CSVRecordBuilder;
import org.kitesdk.data.spi.filesystem.CSVUtil;
import org.kitesdk.shaded.com.google.common.collect.Lists;

public class CSVRecordParser<E> {
    private final CSVParser parser;
    private final CSVRecordBuilder<E> builder;

    public CSVRecordParser(CSVProperties props, View<E> view, @Nullable List<String> header) {
        this(props, view.getDataset().getDescriptor().getSchema(), view.getType(), header);
    }

    public CSVRecordParser(CSVProperties props, Schema schema, Class<E> type, @Nullable List<String> header) {
        this.parser = CSVUtil.newParser(props);
        this.builder = new CSVRecordBuilder<E>(DataModelUtil.getReaderSchema(type, schema), type, CSVRecordParser.getHeader(props, header));
    }

    public E read(String line) {
        return this.read(line, null);
    }

    public E read(String line, @Nullable E reuse) {
        try {
            return this.builder.makeRecord(this.parser.parseLine(line), reuse);
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot parse line: " + line, e);
        }
    }

    public static List<String> getHeader(CSVProperties props, @Nullable List<String> header) {
        if (header != null) {
            return header;
        }
        if (props.header != null) {
            try {
                return Lists.newArrayList(CSVUtil.newParser(props).parseLine(props.header));
            }
            catch (IOException e) {
                throw new DatasetIOException("Failed to parse header from properties: " + props.header, e);
            }
        }
        return null;
    }
}

