/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.spi.filesystem.AvroAppender;
import org.kitesdk.data.spi.filesystem.FileSystemWriter;
import org.kitesdk.data.spi.filesystem.ParquetAppender;
import org.kitesdk.shaded.com.google.common.base.Objects;
import org.kitesdk.shaded.com.google.common.io.Closeables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DurableParquetAppender<E extends IndexedRecord>
implements FileSystemWriter.FileAppender<E> {
    private static final Logger LOG = LoggerFactory.getLogger(DurableParquetAppender.class);
    private final Path path;
    private final Path avroPath;
    private final AvroAppender<E> avroAppender;
    private final ParquetAppender<E> parquetAppender;
    private final Schema schema;
    private final FileSystem fs;

    public DurableParquetAppender(FileSystem fs, Path path, Schema schema, Configuration conf, CompressionType compressionType) {
        this.fs = fs;
        this.path = path;
        this.schema = schema;
        this.avroPath = DurableParquetAppender.avroPath(path);
        this.avroAppender = new AvroAppender(fs, this.avroPath, schema, CompressionType.Snappy);
        this.parquetAppender = new ParquetAppender(fs, path, schema, conf, compressionType);
    }

    @Override
    public void open() throws IOException {
        this.avroAppender.open();
        this.parquetAppender.open();
    }

    @Override
    public void append(E entity) throws IOException {
        this.avroAppender.append(entity);
        this.parquetAppender.append(entity);
    }

    @Override
    public void flush() throws IOException {
        this.avroAppender.flush();
    }

    @Override
    public void sync() throws IOException {
        this.avroAppender.sync();
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.avroAppender, false);
        Closeables.close(this.parquetAppender, false);
    }

    @Override
    public void cleanup() throws IOException {
        this.fs.delete(this.avroPath, false);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("fs", this.fs).add("path", this.path).add("schema", this.schema).add("avroPath", this.avroPath).toString();
    }

    private static Path avroPath(Path path) {
        return new Path(path.getParent(), path.getName() + ".avro");
    }
}

