/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemUtil.class);

    public static void ensureLocationExists(DatasetDescriptor descriptor, Configuration conf) {
        Preconditions.checkNotNull(descriptor.getLocation(), "Cannot get FileSystem for a descriptor with no location");
        Path dataPath = new Path(descriptor.getLocation());
        FileSystem fs = null;
        try {
            fs = dataPath.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot get FileSystem for descriptor: " + descriptor, e);
        }
        try {
            if (!fs.exists(dataPath)) {
                fs.mkdirs(dataPath);
            }
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot access data location", e);
        }
    }

    static boolean cleanlyDelete(FileSystem fs, Path root, Path path) {
        Preconditions.checkNotNull(fs, "File system cannot be null");
        Preconditions.checkNotNull(root, "Root path cannot be null");
        Preconditions.checkNotNull(path, "Path to delete cannot be null");
        try {
            boolean deleted;
            Path relativePath = path.isAbsolute() ? new Path(root.toUri().relativize(path.toUri())) : path;
            if (relativePath.isAbsolute()) {
                LOG.debug("Deleting path {}", (Object)path);
                deleted = fs.delete(path, true);
            } else {
                FileStatus[] stats;
                Path absolute = new Path(root, relativePath);
                LOG.debug("Deleting path {}", (Object)absolute);
                deleted = fs.delete(absolute, true);
                Path current = absolute.getParent();
                while (!(current.equals((Object)root) || current.getParent() == null || (stats = fs.listStatus(current)) != null && stats.length != 0)) {
                    LOG.debug("Deleting empty path {}", (Object)current);
                    deleted = fs.delete(current, true) || deleted;
                    current = current.getParent();
                }
            }
            return deleted;
        }
        catch (IOException ex) {
            throw new DatasetIOException("Could not cleanly delete path:" + path, ex);
        }
    }
}

